<?php
/**
 * Theme sprecific functions and definitions
 */

/* Theme setup section
------------------------------------------------------------------- */

// Set the content width based on the theme's design and stylesheet.
if ( ! isset( $content_width ) ) $content_width = 1170; /* pixels */

// Add theme specific actions and filters
// Attention! Function were add theme specific actions and filters handlers must have priority 1
if ( !function_exists( 'runcrew_theme_setup' ) ) {
	add_action( 'runcrew_action_before_init_theme', 'runcrew_theme_setup', 1 );
	function runcrew_theme_setup() {

		// Add default posts and comments RSS feed links to head
		add_theme_support( 'automatic-feed-links' );

		// Enable support for Post Thumbnails
		add_theme_support( 'post-thumbnails' );

		// Custom header setup
		add_theme_support( 'custom-header', array('header-text'=>false));

		// Custom backgrounds setup
		add_theme_support( 'custom-background');

		// Supported posts formats
		add_theme_support( 'post-formats', array('gallery', 'video', 'audio', 'link', 'quote', 'image', 'status', 'aside', 'chat') );

		// Autogenerate title tag
		add_theme_support('title-tag');

		// Add user menu
		add_theme_support('nav-menus');

		// WooCommerce Support
		add_theme_support( 'woocommerce' );

		// Register theme menus
		add_filter( 'runcrew_filter_add_theme_menus',		'runcrew_add_theme_menus' );

		// Register theme sidebars
		add_filter( 'runcrew_filter_add_theme_sidebars',	'runcrew_add_theme_sidebars' );

		// Set options for importer
		add_filter( 'runcrew_filter_importer_options',		'runcrew_set_importer_options' );

		// Add theme required plugins
		add_filter( 'runcrew_filter_required_plugins',		'runcrew_add_required_plugins' );

        add_filter('runcrew_filter_add_styles_inline', 'runcrew_page_preloader_style_css');

		// Add theme specified classes into the body
		add_filter( 'body_class', 'runcrew_body_classes' );

		// Set list of the theme required plugins
		runcrew_storage_set('required_plugins', array(
			'buddypress',		// Attention! This slug used to install both BuddyPress and bbPress
			'essgrids',
			'revslider',
			'tribe_events',
			'trx_utils',
			'visual_composer',
			'woocommerce',
			'elegro-payment',
			'instagram-feed',
			'trx_updater',
			'contact-form-7',
			'mailchimp-for-wp'
			)
		);

        // Gutenberg support
        add_theme_support( 'align-wide' );

        runcrew_storage_set('demo_data_url',  esc_url(runcrew_get_protocol() . '://demofiles.ancorathemes.com/runcrew/'));
	}
}


// Add/Remove theme nav menus
if ( !function_exists( 'runcrew_add_theme_menus' ) ) {
	function runcrew_add_theme_menus($menus) {
		return $menus;
	}
}

// Add theme specific widgetized areas
if ( !function_exists( 'runcrew_add_theme_sidebars' ) ) {
	function runcrew_add_theme_sidebars($sidebars=array()) {
		if (is_array($sidebars)) {
			$theme_sidebars = array(
				'sidebar_main'		=> esc_html__( 'Main Sidebar', 'runcrew' ),
				'sidebar_footer'	=> esc_html__( 'Footer Sidebar', 'runcrew' ),
				'sidebar_services'	=> esc_html__( 'Services Sidebar', 'runcrew' )
			);
			if (function_exists('runcrew_exists_woocommerce') && runcrew_exists_woocommerce()) {
				$theme_sidebars['sidebar_cart']  = esc_html__( 'WooCommerce Cart Sidebar', 'runcrew' );
			}
			$sidebars = array_merge($theme_sidebars, $sidebars);
		}
		return $sidebars;
	}
}


// Add theme required plugins
if ( !function_exists( 'runcrew_add_required_plugins' ) ) {
	function runcrew_add_required_plugins($plugins) {
		$plugins[] = array(
			'name' 		=> esc_html__('ThemeREX Utilities', 'runcrew'),
			'version'	=> '3.1.12',					// Minimal required version
			'slug' 		=> 'trx_utils',
			'source'	=> runcrew_get_file_dir('plugins/install/trx_utils.zip'),
			'force_activation'   => false,			// If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
			'force_deactivation' => false,			// If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
			'required' 	=> true
		);
		return $plugins;
	}
}


// Add theme specified classes into the body
if ( !function_exists('runcrew_body_classes') ) {
	function runcrew_body_classes( $classes ) {

		$classes[] = 'runcrew_body';
		$classes[] = 'body_style_' . trim(runcrew_get_custom_option('body_style'));
		$classes[] = 'body_' . (runcrew_get_custom_option('body_filled')=='yes' ? 'filled' : 'transparent');
		$classes[] = 'theme_skin_' . trim(runcrew_get_custom_option('theme_skin'));
		$classes[] = 'article_style_' . trim(runcrew_get_custom_option('article_style'));
		
		$blog_style = runcrew_get_custom_option(is_singular() && !runcrew_storage_get('blog_streampage') ? 'single_style' : 'blog_style');
		$classes[] = 'layout_' . trim($blog_style);
		$classes[] = 'template_' . trim(runcrew_get_template_name($blog_style));
		
		$body_scheme = runcrew_get_custom_option('body_scheme');
		if (empty($body_scheme)  || runcrew_is_inherit_option($body_scheme)) $body_scheme = 'original';
		$classes[] = 'scheme_' . $body_scheme;

		$top_panel_position = runcrew_get_custom_option('top_panel_position');
		if (!runcrew_param_is_off($top_panel_position)) {
			$classes[] = 'top_panel_show';
			$classes[] = 'top_panel_' . trim($top_panel_position);
		} else 
			$classes[] = 'top_panel_hide';
		$classes[] = runcrew_get_sidebar_class();

		if (runcrew_get_custom_option('show_video_bg')=='yes' && (runcrew_get_custom_option('video_bg_youtube_code')!='' || runcrew_get_custom_option('video_bg_url')!=''))
			$classes[] = 'video_bg_show';

		if (runcrew_get_theme_option('page_preloader')!='')
			$classes[] = 'preloader';

		return $classes;
	}
}


//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'runcrew_importer_set_options' ) ) {
    add_filter( 'trx_utils_filter_importer_options', 'runcrew_importer_set_options', 9 );
    function runcrew_importer_set_options( $options=array() ) {
        if ( is_array( $options ) ) {
            // Save or not installer's messages to the log-file
            $options['debug'] = false;
            // Prepare demo data
            if ( is_dir( RUNCREW_THEME_PATH . 'demo/' ) ) {
                $options['demo_url'] = RUNCREW_THEME_PATH . 'demo/';
            } else {
                $options['demo_url'] = esc_url( runcrew_get_protocol().'://demofiles.ancorathemes.com/runcrew/' ); // Demo-site domain
            }

            // Required plugins
            $options['required_plugins'] =  array(
                'bbpress',
                'essential-grid',
                'revslider',
                'the-events-calendar',
                'contact-form-7',
                'js_composer',
                'elegro-payment',
                'woocommerce',
					 'mailchimp-for-wp'
            );

            $options['theme_slug'] = 'runcrew';

            // Set number of thumbnails to regenerate when its imported (if demo data was zipped without cropped images)
            // Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
            $options['regenerate_thumbnails'] = 3;
            // Default demo
            $options['files']['default']['title'] = esc_html__( 'Runcrew Demo', 'runcrew' );
            $options['files']['default']['domain_dev'] = esc_url( runcrew_get_protocol().'://runcrew.upd.ancorathemes.com'); // Developers domain
            $options['files']['default']['domain_demo']= esc_url( runcrew_get_protocol().'://runcrew.ancorathemes.com'); // Demo-site domain

        }
        return $options;
    }
}

// Add page meta to the head
if (!function_exists('runcrew_head_add_page_meta')) {
    add_action('wp_head', 'runcrew_head_add_page_meta', 1);
    function runcrew_head_add_page_meta() {
        ?>
        <meta charset="<?php bloginfo( 'charset' ); ?>" />
        <meta name="viewport" content="width=device-width, initial-scale=1<?php if (runcrew_get_theme_option('responsive_layouts')=='yes') echo ', maximum-scale=1'; ?>">
        <meta name="format-detection" content="telephone=no">

        <link rel="profile" href="//gmpg.org/xfn" />
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

        <?php
    }
}

// Return text for the Privacy Policy checkbox
if ( ! function_exists('runcrew_get_privacy_text' ) ) {
    function runcrew_get_privacy_text() {
        $page = get_option( 'wp_page_for_privacy_policy' );
        $privacy_text = runcrew_get_theme_option( 'privacy_text' );
        return apply_filters( 'runcrew_filter_privacy_text', wp_kses_post(
                $privacy_text
                . ( ! empty( $page ) && ! empty( $privacy_text )
                    // Translators: Add url to the Privacy Policy page
                    ? ' ' . sprintf( __( 'For further details on handling user data, see our %s', 'runcrew' ),
                        '<a href="' . esc_url( get_permalink( $page ) ) . '" target="_blank">'
                        . __( 'Privacy Policy', 'runcrew' )
                        . '</a>' )
                    : ''
                )
            )
        );
    }
}

// Return text for the "I agree ..." checkbox
if ( ! function_exists( 'runcrew_trx_utils_privacy_text' ) ) {
    add_filter( 'trx_utils_filter_privacy_text', 'runcrew_trx_utils_privacy_text' );
    function runcrew_trx_utils_privacy_text( $text='' ) {
        return runcrew_get_privacy_text();
    }
}

// Add theme required plugins
if ( !function_exists( 'runcrew_add_trx_utils' ) ) {
    add_filter( 'trx_utils_active', 'runcrew_add_trx_utils' );
    function runcrew_add_trx_utils($enable=true) {
        return true;
    }
}


// Page preloader options
if ( !function_exists( 'runcrew_page_preloader_style_css' ) ) {
    function runcrew_page_preloader_style_css($css)    {
        if (($preloader=runcrew_get_theme_option('page_preloader'))!='') {
            $clr = runcrew_get_scheme_color('bg_color');
            $css .= '
				body #page_preloader {
					background-color: '. esc_attr($clr) . '; ' .
                    'background-image:url('.esc_url($preloader).'); ' .
                '}';
       }
        return $css;
    }
}

/**
 * Fire the wp_body_open action.
 *
 * Added for backwards compatibility to support pre 5.2.0 WordPress versions.
 */
if ( ! function_exists( 'wp_body_open' ) ) {
    function wp_body_open() {
        /**
         * Triggered after the opening <body> tag.
         */
        do_action('wp_body_open');
    }
}

/* Include framework core files
------------------------------------------------------------------- */
	get_template_part('fw/loader');
?>