<?php
/**
 * RunCrew Framework: Registered Users
 *
 * @package	runcrew
 * @since	runcrew 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Theme init
if (!function_exists('runcrew_users_theme_setup')) {
	add_action( 'runcrew_action_before_init_theme', 'runcrew_users_theme_setup' );
	function runcrew_users_theme_setup() {

		if ( !is_admin() ) {
            // Social Login support
            add_filter( 'trx_utils_filter_social_login', 'runcrew_social_login');
		}
	}
}

// Return Social Login layout (if present)
if (!function_exists('runcrew_social_login')) {
	function runcrew_social_login($sc) {
		return runcrew_get_theme_option('social_login');
	}
}


// Return (and show) user profiles links
if (!function_exists('runcrew_show_user_socials')) {
	function runcrew_show_user_socials($args) {
		$args = array_merge(array(
			'author_id' => 0,										// author's ID
			'allowed' => array(),									// list of allowed social
			'size' => 'small',										// icons size: tiny|small|big
			'shape' => 'square',									// icons shape: square|round
			'style' => runcrew_get_theme_setting('socials_type')=='images' ? 'bg' : 'icons',	// style for show icons: icons|images|bg
			'echo' => true											// if true - show on page, else - only return as string
			), is_array($args) ? $args 
				: array('author_id' => $args));						// If send one number parameter - use it as author's ID
		$output = '';
		$upload_info = wp_upload_dir();
		$upload_url = $upload_info['baseurl'];
		$social_list = runcrew_get_theme_option('social_icons');
		$list = array();
		if (is_array($social_list) && count($social_list) > 0) {
			foreach ($social_list as $soc) {
				if ($args['style'] == 'icons') {
					$parts = explode('-', $soc['icon'], 2);
					$sn = isset($parts[1]) ? $parts[1] : $soc['icon'];
				} else {
					$sn = basename($soc['icon']);
					$sn = runcrew_substr($sn, 0, runcrew_strrpos($sn, '.'));
					if (($pos=runcrew_strrpos($sn, '_'))!==false)
						$sn = runcrew_substr($sn, 0, $pos);
				}
				if (count($args['allowed'])==0 || in_array($sn, $args['allowed'])) {
					$link = get_the_author_meta('user_' . ($sn), $args['author_id']);
					if ($link) {
						$icon = $args['style']=='icons' || runcrew_strpos($soc['icon'], $upload_url)!==false ? $soc['icon'] : runcrew_get_socials_url(basename($soc['icon']));
						$list[] = array(
							'icon'	=> $icon,
							'url'	=> $link
						);
					}
				}
			}
		}
		if (count($list) > 0 ) {
			$output = '<div class="sc_socials sc_socials_size_'.esc_attr($args['size']).' sc_socials_shape_'.esc_attr($args['shape']).' sc_socials_type_' . esc_attr($args['style']) . '">' 
							. trim(runcrew_prepare_socials($list, $show_name=false, $args['style']))
						. '</div>';
			if ($args['echo']) runcrew_show_layout($output);
		}
		return $output;
	}
}
?>