<?php
/**
 * RunCrew Framework: Supported post types settings
 *
 * @package	runcrew
 * @since	runcrew 1.0
 */

// Theme init
if (!function_exists('runcrew_post_type_theme_setup')) {
	add_action( 'runcrew_action_before_init_theme', 'runcrew_post_type_theme_setup', 9 );
	function runcrew_post_type_theme_setup() {
		if ( !runcrew_options_is_used() ) return;
		$post_type = runcrew_admin_get_current_post_type();
		if (empty($post_type)) $post_type = 'post';
		$override_key = runcrew_get_override_key($post_type, 'post_type');
		if ($override_key) {
			// Set post type action
			add_action('save_post',				'runcrew_post_type_save_options');
			add_filter('trx_utils_filter_override_options',		'runcrew_post_type_add_override_options');
			add_action('admin_enqueue_scripts', 'runcrew_post_type_admin_scripts');
			// Create override options
			runcrew_storage_set('post_override_options', array(
				'id' => 'post-override-options',
				'title' => esc_html__('Post Options', 'runcrew'),
				'page' => $post_type,
				'context' => 'normal',
				'priority' => 'high',
				'fields' => array()
				)
			);
		}
	}
}


// Admin scripts
if (!function_exists('runcrew_post_type_admin_scripts')) {
	function runcrew_post_type_admin_scripts() {
	}
}


// Add override options
if (!function_exists('runcrew_post_type_add_override_options')) {
	function runcrew_post_type_add_override_options($boxes = array()) {
        $boxes[] = array_merge(runcrew_storage_get('post_override_options'), array('callback' => 'runcrew_post_type_show_override_options'));
        return $boxes;
	}
}

// Callback function to show fields in override options
if (!function_exists('runcrew_post_type_show_override_options')) {
	function runcrew_post_type_show_override_options() {
		global $post;
		
		$post_type = runcrew_admin_get_current_post_type();
		$override_key = runcrew_get_override_key($post_type, 'post_type');
		
		// Use nonce for verification
		echo '<input type="hidden" name="override_options_post_nonce" value="' .esc_attr(wp_create_nonce(admin_url())).'" />';
		echo '<input type="hidden" name="override_options_post_type" value="'.esc_attr($post_type).'" />';
	
		$custom_options = apply_filters('runcrew_filter_post_load_custom_options', get_post_meta($post->ID, runcrew_storage_get('options_prefix') . '_post_options', true), $post_type, $post->ID);

		$mb = runcrew_storage_get('post_override_options');
		$post_options = runcrew_array_merge(runcrew_storage_get('options'), $mb['fields']);

		do_action('runcrew_action_post_before_show_override_options', $post_type, $post->ID);
	
		runcrew_options_page_start(array(
			'data' => $post_options,
			'add_inherit' => true,
			'create_form' => false,
			'buttons' => array('import', 'export'),
			'override' => $override_key
		));

		if (is_array($post_options) && count($post_options) > 0) {
			foreach ($post_options as $id=>$option) { 
				if (!isset($option['override']) || !in_array($override_key, explode(',', $option['override']))) continue;

				$option = apply_filters('runcrew_filter_post_show_custom_field_option', $option, $id, $post_type, $post->ID);
				$meta = isset($custom_options[$id]) 
								? apply_filters('runcrew_filter_post_show_custom_field_value', $custom_options[$id], $option, $id, $post_type, $post->ID) 
								: (isset($option['inherit']) && !$option['inherit'] ? $option['std'] : '');

				do_action('runcrew_action_post_before_show_custom_field', $post_type, $post->ID, $option, $id, $meta);

				runcrew_options_show_field($id, $option, $meta);

				do_action('runcrew_action_post_after_show_custom_field', $post_type, $post->ID, $option, $id, $meta);
			}
		}
	
		runcrew_options_page_stop();
		
		do_action('runcrew_action_post_after_show_override_options', $post_type, $post->ID);
		
	}
}


// Save data from override options
if (!function_exists('runcrew_post_type_save_options')) {
	function runcrew_post_type_save_options($post_id) {

		// verify nonce
		if ( !wp_verify_nonce( runcrew_get_value_gp('override_options_post_nonce'), admin_url() ) )
			return $post_id;

		// check autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
			return $post_id;

		$post_type = isset($_POST['override_options_post_type']) ? runcrew_get_value_gp('override_options_post_type') : runcrew_get_value_gp('post_type');
		$override_key = runcrew_get_override_key($post_type, 'post_type');

		// check permissions
		$capability = 'page';
		$post_types = get_post_types( array( 'name' => $post_type), 'objects' );
		if (!empty($post_types) && is_array($post_types)) {
			foreach ($post_types  as $type) {
				$capability = $type->capability_type;
				break;
			}
		}
		if (!current_user_can('edit_'.($capability), $post_id)) {
			return $post_id;
		}

		$custom_options = array();

		$post_options = array_merge(runcrew_storage_get('options'), runcrew_storage_get_array('post_override_options', 'fields'));

		if (runcrew_options_merge_new_values($post_options, $custom_options, $_POST, 'save', $override_key)) {
			update_post_meta($post_id, runcrew_storage_get('options_prefix') . '_post_options', apply_filters('runcrew_filter_post_save_custom_options', $custom_options, $post_type, $post_id));
		}

		// Init post counters
		global $post;
		if ( !empty($post->ID) && $post_id==$post->ID ) {
            apply_filters('trx_utils_filter_get_post_views', 0, $post_id);
			apply_filters('trx_utils_filter_get_post_likes', 0, $post_id);
		}
	}
}
?>