/**
 * RunCrew Framework: Debug utilities
 *
 * @package	runcrew
 * @since	runcrew 1.0
 */


function runcrew_debug_object(obj) {
	"use strict";
	var html = arguments[1] ? arguments[1] : false;				// Tags decorate
	var recursive = arguments[2] ? arguments[2] : false;		// Show inner objects (arrays)
	var showMethods = arguments[3] ? arguments[3] : false;		// Show object's methods
	var level = arguments[4] ? arguments[4] : 0;				// Nesting level (for internal usage only)
	var dispStr = "";
	var addStr = "";
	if (level>0) {
		dispStr += (obj===null ? "null" : typeof(obj)) + (html ? "\n<br />" : "\n");
		addStr = runcrew_replicate(html ? '&nbsp;' : ' ', level*2);
	}
	if (obj!==null) {
		for (var prop in obj) {
			if (!showMethods && typeof(obj[prop])=='function')
				continue;
			if (recursive && (typeof(obj[prop])=='object' || typeof(obj[prop])=='array') && obj[prop]!=obj)
				dispStr += addStr + (html ? "<b>" : "")+prop+(html ? "</b>" : "")+'='+runcrew_debug_object(obj[prop], html, recursive, showMethods, level+1);
			else
				dispStr += addStr + (html ? "<b>" : "")+prop+(html ? "</b>" : "")+'='+(typeof(obj[prop])=='string' ? '"' : '')+obj[prop]+(typeof(obj[prop])=='string' ? '"' : '')+(html ? "\n<br />" : "\n");
		}
	}
	return dispStr;
}

function runcrew_debug_log(s) {
    "use strict";
	if (RUNCREW_STORAGE['user_logged_in']) {
		if (jQuery('#debug_log').length == 0) {
			jQuery('body').append('<div id="debug_log"><span id="debug_log_close" onclick="jQuery(\'#debug_log\').hide();">x</span><div id="debug_log_content"></div></div>'); 
		}
		jQuery('#debug_log_content').append('<br>'+s);
		jQuery('#debug_log').show();
	}
}

(function(){
    "use strict";
    window.dcl===undefined && (window.dcl = function(s) { "use strict"; console.log(s); });
    window.dco===undefined && (window.dco = function(s,h,r) { "use strict"; console.log(seventrees_debug_object(s,h,r)); });
    window.dal===undefined && (window.dal = function(s) { "use strict"; if (SEVENTREES_STORAGE['user_logged_in']) alert(s); });
    window.dao===undefined && (window.dao = function(s,h,r) { "use strict"; if (SEVENTREES_STORAGE['user_logged_in']) alert(seventrees_debug_object(s,h,r)); });
    window.ddl===undefined && (window.ddl = function(s) { "use strict"; seventrees_debug_log(s); });
    window.ddo===undefined && (window.ddo = function(s,h,r) { "use strict"; seventrees_debug_log(seventrees_debug_object(s,h,r)); });
})();
