<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('runcrew_cf7_theme_setup')) {
    add_action( 'runcrew_action_before_init_theme', 'runcrew_cf7_theme_setup', 1 );
    function runcrew_cf7_theme_setup() {

		if (runcrew_exists_cf7()) {
			add_filter('wpcf7_autop_or_not', '__return_false');
			add_action('runcrew_action_add_styles', 				'runcrew_cf7_frontend_scripts' );
		}

        if (is_admin()) {
            add_filter( 'runcrew_filter_required_plugins', 'runcrew_cf7_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'runcrew_cf7_required_plugins' ) ) {
    function runcrew_cf7_required_plugins($list=array()) {
        if (in_array('contact-form-7', (array)runcrew_storage_get('required_plugins')))
            $list[] = array(
                'name'         => esc_html__('Contact Form 7', 'runcrew'),
                'slug'         => 'contact-form-7',
                'required'     => false
            );
        return $list;
    }
}


// Check if cf7 installed and activated
if ( !function_exists( 'runcrew_exists_cf7' ) ) {
	function runcrew_exists_cf7() {
		return class_exists('WPCF7') && class_exists('WPCF7_ContactForm');
	}
}

// Enqueue WooCommerce custom styles
if ( !function_exists( 'runcrew_cf7_frontend_scripts' ) ) {
	function runcrew_cf7_frontend_scripts() {
			if (file_exists(runcrew_get_file_dir('css/plugin.contact-form-7.css')))
				wp_enqueue_style( 'runcrew-plugin-contact-form-7-style',  runcrew_get_file_url('css/plugin.contact-form-7.css'), array(), null );
	}
}

?>