<?php
/* Instagram Feed support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('runcrew_elegro_payment_theme_setup')) {
    add_action( 'runcrew_action_before_init_theme', 'runcrew_elegro_payment_theme_setup', 1 );
    function runcrew_elegro_payment_theme_setup() {
        if (is_admin()) {
            add_filter( 'runcrew_filter_required_plugins',		'runcrew_elegro_payment_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'runcrew_elegro_payment_required_plugins' ) ) {
    function runcrew_elegro_payment_required_plugins($list=array()) {
        if (in_array('elegro-payment', (array)runcrew_storage_get('required_plugins'))) {
            $list[] = array(
                'name' 		=> esc_html__('Elegro Payment', 'runcrew'),
                'slug' 		=> 'elegro-payment',
                'required' 	=> false
            );
        }
        return $list;
    }
}

// Check if Instagram Feed installed and activated
if ( !function_exists( 'runcrew_exists_elegro_payment' ) ) {
    function runcrew_exists_elegro_payment() {
        return function_exists('init_Elegro_Payment');
    }
}