<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('runcrew_essgrids_theme_setup')) {
	add_action( 'runcrew_action_before_init_theme', 'runcrew_essgrids_theme_setup', 1 );
	function runcrew_essgrids_theme_setup() {
		if (is_admin()) {
			add_filter( 'runcrew_filter_required_plugins',				'runcrew_essgrids_required_plugins' );
		}
	}
}


// Check if Ess. Grid installed and activated
if ( !function_exists( 'runcrew_exists_essgrids' ) ) {
	function runcrew_exists_essgrids() {
		return defined( 'ESG_PLUGIN_PATH' ) || defined( 'EG_PLUGIN_PATH' );
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'runcrew_essgrids_required_plugins' ) ) {
	function runcrew_essgrids_required_plugins($list=array()) {
		if (in_array('essgrids', runcrew_storage_get('required_plugins'))) {
			$path = runcrew_get_file_dir('plugins/install/essential-grid.zip');
			if (file_exists($path)) {
				$list[] = array(
					'name' 		=> esc_html__('Essential Grid', 'runcrew'),
					'slug' 		=> 'essential-grid',
					'version'   => '3.0.19',
					'source'	=> $path,
					'required' 	=> false
					);
			}
		}
		return $list;
	}
}
