<?php
/* The GDPR Framework support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('runcrew_gdpr_compliance_theme_setup')) {
    add_action( 'runcrew_action_before_init_theme', 'runcrew_gdpr_compliance_theme_setup', 1 );
    function runcrew_gdpr_compliance_theme_setup() {
        if (is_admin()) {
            add_filter( 'runcrew_filter_required_plugins', 'runcrew_gdpr_compliance_required_plugins' );
        }
    }
}

// Check if Instagram Widget installed and activated
if ( !function_exists( 'runcrew_exists_gdpr_compliance' ) ) {
    function runcrew_exists_gdpr_compliance() {
        return defined( 'WP_GDPR_C_SLUG' );
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'runcrew_gdpr_compliance_required_plugins' ) ) {
    function runcrew_gdpr_compliance_required_plugins($list=array()) {
        if (in_array('gdpr-compliance', (array)runcrew_storage_get('required_plugins')))
            $list[] = array(
                'name'         => esc_html__('Cookie Information', 'runcrew'),
                'slug'         => 'wp-gdpr-compliance',
                'required'     => false
            );
        return $list;
    }
}