<?php
/* Gutenberg support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('runcrew_gutenberg_theme_setup')) {
    add_action( 'runcrew_action_before_init_theme', 'runcrew_gutenberg_theme_setup', 1 );
    function runcrew_gutenberg_theme_setup() {
        add_action( 'enqueue_block_editor_assets', 'runcrew_gutenberg_editor_scripts' );
        if (is_admin()) {
            add_filter( 'runcrew_filter_required_plugins', 'runcrew_gutenberg_required_plugins' );
        }
    }
}

// Check if Instagram Widget installed and activated
if ( !function_exists( 'runcrew_exists_gutenberg' ) ) {
    function runcrew_exists_gutenberg() {
        return function_exists( 'the_gutenberg_project' ) && function_exists( 'register_block_type' );
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'runcrew_gutenberg_required_plugins' ) ) {
    function runcrew_gutenberg_required_plugins($list=array()) {
        if (in_array('gutenberg', (array)runcrew_storage_get('required_plugins')))
            $list[] = array(
                'name'         => esc_html__('Gutenberg', 'runcrew'),
                'slug'         => 'gutenberg',
                'required'     => false
            );
        return $list;
    }
}

// Save CSS with custom colors and fonts to the gutenberg-editor-style.css
if ( ! function_exists( 'runcrew_gutenberg_save_css' ) ) {
    add_action( 'runcrew_action_compile_less', 'runcrew_gutenberg_save_css', 99 );
    function runcrew_gutenberg_save_css() {

        $msg = '/* ' . esc_html__( "ATTENTION! This file was generated automatically! Don't change it!!!", 'runcrew' )
            . "\n----------------------------------------------------------------------- */\n";

        // Get main styles
        $css = runcrew_fgc( runcrew_get_file_dir( 'style.css' ) );

        // Append theme-vars styles
        $css .= runcrew_fgc( runcrew_get_file_dir( 'skins/default/skin.css' ) );

        // Add context class to each selector
        if ( function_exists( 'trx_utils_css_add_context' ) ) {

            $css = str_replace('@charset "utf-8";', '', $css );
            $css = preg_replace('!/\*.*?\*/!s', '', $css);
            $css = preg_replace('/\n\s*\n/', "\n", $css);
            // Add context class to each selector
            $css = trx_utils_css_add_context(
                $css,
                array(
                    'context' => '.edit-post-visual-editor ',
                    'context_self' => array( 'html', 'body' )
                )
            );
        }
        // Save styles to the file
        runcrew_fpc( runcrew_get_file_dir( 'css/gutenberg-preview.css' ), $msg . $css );
    }
}

if (!function_exists('runcrew_gutenberg_editor_scripts')) {
    function runcrew_gutenberg_editor_scripts() {
        // Editor styles
        wp_enqueue_style( 'runcrew-gutenberg-preview', runcrew_get_file_url( 'css/gutenberg-preview.css' ), array(), null );

        //Editor scripts
        wp_enqueue_script( 'runcrew-gutenberg-preview', runcrew_get_file_url( 'js/gutenberg-preview.js' ), array( 'jquery' ), null, true );

        $body_scheme = runcrew_get_custom_option('body_scheme');
        if (empty($body_scheme)  || runcrew_is_inherit_option($body_scheme)) $body_scheme = 'original';

        wp_localize_script('runcrew-gutenberg-preview','RUNCREW_STORAGE', array(
            'color_scheme' => trim($body_scheme),
            'media_elements_enabled' => runcrew_get_theme_option('use_mediaelement')=='yes'
        ));
    }
}
