<?php
/* Instagram Feed support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('runcrew_instagram_feed_theme_setup')) {
    add_action( 'runcrew_action_before_init_theme', 'runcrew_instagram_feed_theme_setup', 1 );
    function runcrew_instagram_feed_theme_setup() {
        if (is_admin()) {
            add_filter( 'runcrew_filter_required_plugins',					'runcrew_instagram_feed_required_plugins' );
        }
    }
}

// Check if Instagram Feed installed and activated
if ( !function_exists( 'runcrew_exists_instagram_feed' ) ) {
    function runcrew_exists_instagram_feed() {
        return defined('SBIVER');
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'runcrew_instagram_feed_required_plugins' ) ) {
    function runcrew_instagram_feed_required_plugins($list=array()) {
        if (in_array('instagram-feed', runcrew_storage_get('required_plugins')))
            $list[] = array(
                'name' 		=> esc_html__('Instagram Feed', 'runcrew'),
                'slug' 		=> 'instagram-feed',
                'required' 	=> false
            );
        return $list;
    }
}