<?php
/* Mail Chimp support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('runcrew_mailchimp_theme_setup')) {
	add_action( 'runcrew_action_before_init_theme', 'runcrew_mailchimp_theme_setup', 1 );
	function runcrew_mailchimp_theme_setup() {
		if (is_admin()) {
			add_filter( 'runcrew_filter_required_plugins',					'runcrew_mailchimp_required_plugins' );
		}
	}
}

// Check if Instagram Feed installed and activated
if ( !function_exists( 'runcrew_exists_mailchimp' ) ) {
	function runcrew_exists_mailchimp() {
		return function_exists('mc4wp_load_plugin');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'runcrew_mailchimp_required_plugins' ) ) {
	function runcrew_mailchimp_required_plugins($list=array()) {
		if (in_array('mailchimp-for-wp', runcrew_storage_get('required_plugins')))
			$list[] = array(
				'name' 		=> esc_html__('MailChimp for WP', 'runcrew'),
				'slug' 		=> 'mailchimp-for-wp',
				'required' 	=> false
			);
		return $list;
	}
}