<?php
/* ThemeREX Updater support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('runcrew_trx_updater_theme_setup')) {
    add_action( 'runcrew_action_before_init_theme', 'runcrew_trx_updater_theme_setup', 1 );
    function runcrew_trx_updater_theme_setup() {
        if (is_admin()) {
            add_filter( 'runcrew_filter_required_plugins',		'runcrew_trx_updater_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'runcrew_trx_updater_required_plugins' ) ) {
    function runcrew_trx_updater_required_plugins($list=array()) {
        if (in_array('trx_updater', (array)runcrew_storage_get('required_plugins'))) {
            $list[] = array(
                'name' 		=> esc_html__('ThemeREX Updater', 'runcrew'),
                'slug' 		=> 'trx_updater',
                'version'   => '2.1.0',
                'source'	=> runcrew_get_file_dir('plugins/install/trx_updater.zip'),
                'required' 	=> false
            );
        }
        return $list;
    }
}