<?php
/* WPBakery PageBuilder support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('runcrew_vc_theme_setup')) {
	add_action( 'runcrew_action_before_init_theme', 'runcrew_vc_theme_setup', 1 );
	function runcrew_vc_theme_setup() {
		if (runcrew_exists_visual_composer()) {
			add_action('runcrew_action_add_styles',		 				'runcrew_vc_frontend_scripts' );
		}
		if (is_admin()) {
			add_filter( 'runcrew_filter_required_plugins',					'runcrew_vc_required_plugins' );
		}
	}
}

// Check if WPBakery PageBuilder installed and activated
if ( !function_exists( 'runcrew_exists_visual_composer' ) ) {
	function runcrew_exists_visual_composer() {
		return class_exists('Vc_Manager');
	}
}

// Check if WPBakery PageBuilder in frontend editor mode
if ( !function_exists( 'runcrew_vc_is_frontend' ) ) {
	function runcrew_vc_is_frontend() {
		return (isset($_GET['vc_editable']) && $_GET['vc_editable']=='true')
			|| (isset($_GET['vc_action']) && $_GET['vc_action']=='vc_inline');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'runcrew_vc_required_plugins' ) ) {
	function runcrew_vc_required_plugins($list=array()) {
		if (in_array('visual_composer', runcrew_storage_get('required_plugins'))) {
			$path = runcrew_get_file_dir('plugins/install/js_composer.zip');
			if (file_exists($path)) {
				$list[] = array(
					'name' 		=> esc_html__('WPBakery PageBuilder', 'runcrew'),
					'slug' 		=> 'js_composer',
					'version'   => '7.0',
					'source'	=> $path,
					'required' 	=> false
				);
			}
		}
		return $list;
	}
}

// Enqueue VC custom styles
if ( !function_exists( 'runcrew_vc_frontend_scripts' ) ) {
	function runcrew_vc_frontend_scripts() {
		if (file_exists(runcrew_get_file_dir('css/plugin.visual-composer.css')))
			wp_enqueue_style( 'runcrew-plugin-visual-composer-style',  runcrew_get_file_url('css/plugin.visual-composer.css'), array(), null );
	}
}