<?php
/* WordPress Social Login support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('runcrew_wordpress_social_login_theme_setup')) {
	add_action( 'runcrew_action_before_init_theme', 'runcrew_wordpress_social_login_theme_setup', 1 );
	function runcrew_wordpress_social_login_theme_setup() {
		if (is_admin()) {
			add_filter( 'runcrew_filter_required_plugins',				'runcrew_wordpress_social_login_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'runcrew_wordpress_social_login_required_plugins' ) ) {
	function runcrew_wordpress_social_login_required_plugins($list=array()) {
		if (in_array('wordpress-social-login', runcrew_storage_get('required_plugins'))) {
            $list[] = array(
                'name' 		=> 'WordPress Social Login',
                'slug' 		=> 'wordpress-social-login',
                'required' 	=> false
                );
		}
		return $list;
	}
}
?>