<?php

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }


/* Theme setup section
-------------------------------------------------------------------- */

if ( !function_exists( 'runcrew_template_no_search_theme_setup' ) ) {
	add_action( 'runcrew_action_before_init_theme', 'runcrew_template_no_search_theme_setup', 1 );
	function runcrew_template_no_search_theme_setup() {
		runcrew_add_template(array(
			'layout' => 'no-search',
			'mode'   => 'internal',
			'title'  => esc_html__('No search results found', 'runcrew')
		));
	}
}

// Template output
if ( !function_exists( 'runcrew_template_no_search_output' ) ) {
	function runcrew_template_no_search_output($post_options, $post_data) {
		?>
		<article class="post_item">
			<div class="post_content">
				<h2 class="post_title"><?php echo sprintf(esc_html__('Search: %s', 'runcrew'), get_search_query()); ?></h2>
				<p><?php esc_html_e( 'Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'runcrew' ); ?></p>
				<p><?php echo wp_kses_data( sprintf(__('Go back, or return to <a href="%s">%s</a> home page to choose a new page.', 'runcrew'), esc_url(home_url('/')), get_bloginfo()) ); ?>
				<br><?php esc_html_e('Please report any broken links to our team.', 'runcrew'); ?></p>
				<?php if(function_exists('runcrew_sc_search')) runcrew_show_layout(runcrew_sc_search(array('state'=>"fixed"))); ?>
			</div>	<!-- /.post_content -->
		</article>	<!-- /.post_item -->
		<?php
	}
}
?>