<?php
/**
 * RunCrew Framework: shortcodes manipulations
 *
 * @package	runcrew
 * @since	runcrew 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Theme init
if (!function_exists('runcrew_sc_theme_setup')) {
	add_action( 'runcrew_action_init_theme', 'runcrew_sc_theme_setup', 1 );
	function runcrew_sc_theme_setup() {
		// Add sc stylesheets
		add_action('runcrew_action_add_styles', 'runcrew_sc_add_styles', 1);
	}
}

if (!function_exists('runcrew_sc_theme_setup2')) {
	add_action( 'runcrew_action_before_init_theme', 'runcrew_sc_theme_setup2' );
	function runcrew_sc_theme_setup2() {

		if ( !is_admin() || isset($_POST['action']) ) {
			// Enable/disable shortcodes in excerpt
			add_filter('the_excerpt', 					'runcrew_sc_excerpt_shortcodes');
	
			// Prepare shortcodes in the content
			if (function_exists('runcrew_sc_prepare_content')) runcrew_sc_prepare_content();
		}

		// Add init script into shortcodes output in VC frontend editor
		add_filter('runcrew_shortcode_output', 'runcrew_sc_add_scripts', 10, 4);

		// AJAX: Send contact form data
		add_action('wp_ajax_send_form',			'runcrew_sc_form_send');
		add_action('wp_ajax_nopriv_send_form',	'runcrew_sc_form_send');

        if (runcrew_exists_tribe_events()) {
            // Register shortcode [trx_events] in the list
            add_action('runcrew_action_shortcodes_list',				'runcrew_tribe_events_reg_shortcodes');
            if (function_exists('runcrew_exists_visual_composer') && runcrew_exists_visual_composer())
                add_action('runcrew_action_shortcodes_list_vc',		'runcrew_tribe_events_reg_shortcodes_vc');
        }
        
		// Show shortcodes list in admin editor
		add_action('media_buttons',				'runcrew_sc_selector_add_in_toolbar', 11);

	}
}


// Register shortcodes styles
if ( !function_exists( 'runcrew_sc_add_styles' ) ) {
	//add_action('runcrew_action_add_styles', 'runcrew_sc_add_styles', 1);
	function runcrew_sc_add_styles() {
		// Shortcodes
		wp_enqueue_style( 'runcrew-shortcodes-style',	trx_utils_get_file_url('shortcodes/theme.shortcodes.css'), array(), null );
	}
}


// Register shortcodes init scripts
if ( !function_exists( 'runcrew_sc_add_scripts' ) ) {
	//add_filter('runcrew_shortcode_output', 'runcrew_sc_add_scripts', 10, 4);
	function runcrew_sc_add_scripts($output, $tag='', $atts=array(), $content='') {

		if (runcrew_storage_empty('shortcodes_scripts_added')) {
			runcrew_storage_set('shortcodes_scripts_added', true);
			wp_enqueue_script( 'runcrew-shortcodes-script', trx_utils_get_file_url('shortcodes/theme.shortcodes.js'), array('jquery'), null, true );	
		}
		
		return $output;
	}
}


/* Prepare text for shortcodes
-------------------------------------------------------------------------------- */

// Prepare shortcodes in content
if (!function_exists('runcrew_sc_prepare_content')) {
	function runcrew_sc_prepare_content() {
		if (function_exists('runcrew_sc_clear_around')) {
			$filters = array(
				array('trx_utils', 'sc', 'clear', 'around'),
				array('widget', 'text'),
				array('the', 'excerpt'),
				array('the', 'content')
			);
			if (function_exists('runcrew_exists_woocommerce') && runcrew_exists_woocommerce()) {
				$filters[] = array('woocommerce', 'template', 'single', 'excerpt');
				$filters[] = array('woocommerce', 'short', 'description');
			}
			if (is_array($filters) && count($filters) > 0) {
				foreach ($filters as $flt)
					add_filter(join('_', $flt), 'runcrew_sc_clear_around', 1);	// Priority 1 to clear spaces before do_shortcodes()
			}
		}
	}
}

// Enable/Disable shortcodes in the excerpt
if (!function_exists('runcrew_sc_excerpt_shortcodes')) {
	function runcrew_sc_excerpt_shortcodes($content) {
		if (!empty($content)) {
			$content = do_shortcode($content);
			//$content = strip_shortcodes($content);
		}
		return $content;
	}
}



/*
// Remove spaces and line breaks between close and open shortcode brackets ][:
[trx_columns]
	[trx_column_item]Column text ...[/trx_column_item]
	[trx_column_item]Column text ...[/trx_column_item]
	[trx_column_item]Column text ...[/trx_column_item]
[/trx_columns]

convert to

[trx_columns][trx_column_item]Column text ...[/trx_column_item][trx_column_item]Column text ...[/trx_column_item][trx_column_item]Column text ...[/trx_column_item][/trx_columns]
*/
if (!function_exists('runcrew_sc_clear_around')) {
	function runcrew_sc_clear_around($content) {
		if (!empty($content)) $content = preg_replace("/\](\s|\n|\r)*\[/", "][", $content);
		return $content;
	}
}






/* Shortcodes support utils
---------------------------------------------------------------------- */

// RunCrew shortcodes load scripts
if (!function_exists('runcrew_sc_load_scripts')) {
	function runcrew_sc_load_scripts() {
		wp_enqueue_script( 'runcrew-shortcodes_admin-script', trx_utils_get_file_url('shortcodes/shortcodes_admin.js'), array('jquery'), null, true );
		wp_enqueue_script( 'runcrew-selection-script',  runcrew_get_file_url('js/jquery.selection.js'), array('jquery'), null, true );
		wp_localize_script( 'runcrew-shortcodes_admin-script', 'RUNCREW_SHORTCODES_DATA', runcrew_storage_get('shortcodes') );
	}
}

// RunCrew shortcodes prepare scripts
if (!function_exists('runcrew_sc_prepare_scripts')) {
	function runcrew_sc_prepare_scripts() {
		if (!runcrew_storage_isset('shortcodes_prepared')) {
			runcrew_storage_set('shortcodes_prepared', true);
			?>
			<script type="text/javascript">
				jQuery(document).ready(function(){
					RUNCREW_STORAGE['shortcodes_cp'] = '<?php echo is_admin() ? (!runcrew_storage_empty('to_colorpicker') ? runcrew_storage_get('to_colorpicker') : 'wp') : 'custom'; ?>';	// wp | tiny | custom
				});
			</script>
			<?php
		}
	}
}

// Show shortcodes list in admin editor
if (!function_exists('runcrew_sc_selector_add_in_toolbar')) {
	//add_action('media_buttons','runcrew_sc_selector_add_in_toolbar', 11);
	function runcrew_sc_selector_add_in_toolbar(){

		if ( !runcrew_options_is_used() ) return;

		runcrew_sc_load_scripts();
		runcrew_sc_prepare_scripts();

		$shortcodes = runcrew_storage_get('shortcodes');
		$shortcodes_list = '<select class="sc_selector"><option value="">&nbsp;'.esc_html__('- Select Shortcode -', 'trx_utils').'&nbsp;</option>';

		if (is_array($shortcodes) && count($shortcodes) > 0) {
			foreach ($shortcodes as $idx => $sc) {
				$shortcodes_list .= '<option value="'.esc_attr($idx).'" title="'.esc_attr($sc['desc']).'">'.esc_html($sc['title']).'</option>';
			}
		}

		$shortcodes_list .= '</select>';

		runcrew_show_layout($shortcodes_list);
	}
}

// RunCrew shortcodes builder settings
require_once trx_utils_get_file_dir('shortcodes/shortcodes_settings.php');

// VC shortcodes settings
if ( class_exists('WPBakeryShortCode') ) {
    require_once trx_utils_get_file_dir('shortcodes/shortcodes_vc.php');
}

// RunCrew shortcodes implementation
// Using get_template_part(), because shortcodes can be replaced in the child theme
require_once trx_utils_get_file_dir('shortcodes/trx_basic/anchor.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/audio.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/blogger.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/br.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/call_to_action.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/chat.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/columns.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/content.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/form.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/googlemap.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/hide.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/image.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/infobox.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/line.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/list.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/price_block.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/promo.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/quote.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/reviews.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/search.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/section.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/skills.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/slider.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/socials.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/table.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/title.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/twitter.php');
require_once trx_utils_get_file_dir('shortcodes/trx_basic/video.php');

require_once trx_utils_get_file_dir('shortcodes/trx_optional/accordion.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/button.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/countdown.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/dropcaps.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/emailer.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/highlight.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/icon.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/number.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/parallax.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/popup.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/price.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/tabs.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/toggles.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/tooltip.php');
require_once trx_utils_get_file_dir('shortcodes/trx_optional/zoom.php');


/**
 * CPT Shortcode + VC
 */
if (!function_exists('runcrew_cpt_theme_setup')) {
	add_action( 'runcrew_action_before_init_theme', 'runcrew_cpt_theme_setup',1 );
	function runcrew_cpt_theme_setup() {
		
		// Register shortcodes [trx_services] and [trx_services_item]
		add_action('runcrew_action_shortcodes_list',		'runcrew_services_reg_shortcodes');
		if (function_exists('runcrew_exists_visual_composer') && runcrew_exists_visual_composer())
			add_action('runcrew_action_shortcodes_list_vc','runcrew_services_reg_shortcodes_vc');

		// Register shortcodes [trx_testimonials] and [trx_testimonials_item]
		add_action('runcrew_action_shortcodes_list',		'runcrew_testimonials_reg_shortcodes');
		if (function_exists('runcrew_exists_visual_composer') && runcrew_exists_visual_composer())
			add_action('runcrew_action_shortcodes_list_vc','runcrew_testimonials_reg_shortcodes_vc');

		// Register shortcodes [trx_team] and [trx_team_item]
		add_action('runcrew_action_shortcodes_list',		'runcrew_team_reg_shortcodes');
		if (function_exists('runcrew_exists_visual_composer') && runcrew_exists_visual_composer())
			add_action('runcrew_action_shortcodes_list_vc','runcrew_team_reg_shortcodes_vc');

		if(runcrew_exists_woocommerce()){
            add_action('runcrew_action_shortcodes_list', 			'runcrew_woocommerce_reg_shortcodes', 20);
            if (function_exists('runcrew_exists_visual_composer') && runcrew_exists_visual_composer())
                add_action('runcrew_action_shortcodes_list_vc',	'runcrew_woocommerce_reg_shortcodes_vc', 20);
        }

		if (runcrew_exists_revslider()) {
			add_filter( 'runcrew_filter_shortcodes_params',			'runcrew_revslider_shortcodes_params' );
		}
	}
}





// Shortcodes
//------------------------------------------------------------------------

if ( !function_exists( 'runcrew_sc_events' ) ) {
	function runcrew_sc_events($atts, $content=null){
		if (runcrew_in_shortcode_blogger()) return '';
		extract(runcrew_html_decode(shortcode_atts(array(
			// Individual params
			"style" => "events-1",
			"columns" => 4,
			"slider" => "no",
			"slides_space" => 0,
			"controls" => "no",
			"interval" => "",
			"autoheight" => "no",
			"align" => "",
			"ids" => "",
			"cat" => "",
			"count" => 4,
			"offset" => "",
			"orderby" => "event_date",
			"order" => "asc",
			"readmore" => esc_html__('Read more', 'trx_utils'),
			"title" => "",
			"subtitle" => "",
			"description" => "",
			"link_caption" => esc_html__('Learn more', 'trx_utils'),
			"link" => '',
			"scheme" => '',
			// Common params
			"id" => "",
			"class" => "",
			"animation" => "",
			"css" => "",
			"width" => "",
			"height" => "",
			"top" => "",
			"bottom" => "",
			"left" => "",
			"right" => ""
		), $atts)));

		if (empty($id)) $id = "sc_events_".str_replace('.', '', mt_rand());
		if (empty($width)) $width = "100%";
		if (!empty($height) && runcrew_param_is_on($autoheight)) $autoheight = "no";
		if (empty($interval)) $interval = mt_rand(5000, 10000);

		$class .= ($class ? ' ' : '') . runcrew_get_css_position_as_classes($top, $right, $bottom, $left);

		$ws = runcrew_get_css_dimensions_from_values($width);
		$hs = runcrew_get_css_dimensions_from_values('', $height);
		$css .= ($hs) . ($ws);

		$count = max(1, (int) $count);
		$columns = max(1, min(12, (int) $columns));
		if ($count < $columns) $columns = $count;

		if (runcrew_param_is_on($slider)) runcrew_enqueue_slider('swiper');

		$output = '<div' . ($id ? ' id="'.esc_attr($id).'_wrap"' : '')
			. ' class="sc_events_wrap'
			. ($scheme && !runcrew_param_is_off($scheme) && !runcrew_param_is_inherit($scheme) ? ' scheme_'.esc_attr($scheme) : '')
			.'">'
			. '<div' . ($id ? ' id="'.esc_attr($id).'"' : '')
			. ' class="sc_events'
			. ' sc_events_style_'.esc_attr($style)
			. ' ' . esc_attr(runcrew_get_template_property($style, 'container_classes'))
			. (!empty($class) ? ' '.esc_attr($class) : '')
			. ($align!='' && $align!='none' ? ' align'.esc_attr($align) : '')
			. '"'
			. ($css!='' ? ' style="'.esc_attr($css).'"' : '')
			. (!runcrew_param_is_off($animation) ? ' data-animation="'.esc_attr(runcrew_get_animation_classes($animation)).'"' : '')
			. '>'
			. (!empty($subtitle) ? '<h6 class="sc_events_subtitle sc_item_subtitle">' . trim(runcrew_strmacros($subtitle)) . '</h6>' : '')
			. (!empty($title) ? '<h2 class="sc_events_title sc_item_title' . (empty($description) ? ' sc_item_title_without_descr' : ' sc_item_title_with_descr') . '">' . trim(runcrew_strmacros($title)) . '</h2>' : '')
			. (!empty($description) ? '<div class="sc_events_descr sc_item_descr">' . trim(runcrew_strmacros($description)) . '</div>' : '')
			. (runcrew_param_is_on($slider)
				? ('<div class="sc_slider_swiper swiper-slider-container'
					. ' ' . esc_attr(runcrew_get_slider_controls_classes($controls))
					. (runcrew_param_is_on($autoheight) ? ' sc_slider_height_auto' : '')
					. ($hs ? ' sc_slider_height_fixed' : '')
					. '"'
					. (!empty($width) && runcrew_strpos($width, '%')===false ? ' data-old-width="' . esc_attr($width) . '"' : '')
					. (!empty($height) && runcrew_strpos($height, '%')===false ? ' data-old-height="' . esc_attr($height) . '"' : '')
					. ((int) $interval > 0 ? ' data-interval="'.esc_attr($interval).'"' : '')
					. ($columns > 1 ? ' data-slides-per-view="' . esc_attr($columns) . '"' : '')
					. ($slides_space > 0 ? ' data-slides-space="' . esc_attr($slides_space) . '"' : '')
					. '>'
					. '<div class="slides swiper-wrapper">')
				: ($columns > 1
					? '<div class="sc_columns columns_wrap">'
					: '')
			);

		$content = do_shortcode($content);

		global $post;

		if (!empty($ids)) {
			$posts = explode(',', $ids);
			$count = count($posts);
		}

		$args = array(
			'post_type' => Tribe__Events__Main::POSTTYPE,
			'post_status' => 'publish',
			'posts_per_page' => $count,
			'ignore_sticky_posts' => true,
            'tribe_suppress_query_filters' => true,
			'order' => $order=='asc' ? 'asc' : 'desc',
			'readmore' => $readmore
		);

		if ($offset > 0 && empty($ids)) {
			$args['offset'] = $offset;
		}

		if (empty($ids)) {
			$args['meta_query'] = array(
				array(
					'key' => '_EventStartDate',
					'value' => date('Y-m-d'),
					'compare' => '>='
				)
			);
		}

		$args = runcrew_query_add_sort_order($args, $orderby, $order);
		$args = runcrew_query_add_posts_and_cats($args, $ids, Tribe__Events__Main::POSTTYPE, $cat, Tribe__Events__Main::TAXONOMY);
		$query = new WP_Query( $args );

		$post_number = 0;

		while ( $query->have_posts() ) {
			$query->the_post();
			$post_number++;
			$args = array(
				'layout' => $style,
				'show' => false,
				'number' => $post_number,
				'posts_on_page' => ($count > 0 ? $count : $query->found_posts),
				"descr" => runcrew_get_custom_option('post_excerpt_maxlength'.($columns > 1 ? '_masonry' : '')),
				"orderby" => $orderby,
				'content' => false,
				'terms_list' => false,
				'readmore' => $readmore,
				'columns_count' => $columns,
				'slider' => $slider,
				'tag_id' => $id ? $id . '_' . $post_number : '',
				'tag_class' => '',
				'tag_animation' => '',
				'tag_css' => '',
				'tag_css_wh' => $ws . $hs
			);
			$output .= runcrew_show_post_layout($args);
		}
		wp_reset_postdata();

		if (runcrew_param_is_on($slider)) {
			$output .= '</div>'
				. '<div class="sc_slider_controls_wrap"><a class="sc_slider_prev" href="#"></a><a class="sc_slider_next" href="#"></a></div>'
				. '<div class="sc_slider_pagination_wrap"></div>'
				. '</div>';
		} else if ($columns > 1) {
			$output .= '</div>';
		}

		$output .=  (!empty($link) ? '<div class="sc_events_button sc_item_button">'.runcrew_do_shortcode('[trx_button link="'.esc_url($link).'" icon="icon-right"]'.esc_html($link_caption).'[/trx_button]').'</div>' : '')
			. '</div><!-- /.sc_events -->'
			. '</div><!-- /.sc_envents_wrap -->';

		// Add template specific scripts and styles
		do_action('runcrew_action_blog_scripts', $style);

		return apply_filters('runcrew_shortcode_output', $output, 'trx_events', $atts, $content);
	}
	add_shortcode('trx_events', 'runcrew_sc_events');
}
// ---------------------------------- [/trx_events] ---------------------------------------



// Add [trx_events] in the shortcodes list
if (!function_exists('runcrew_tribe_events_reg_shortcodes')) {
	function runcrew_tribe_events_reg_shortcodes() {
		if (runcrew_storage_isset('shortcodes')) {

			$groups		= runcrew_get_list_terms(false, Tribe__Events__Main::TAXONOMY);
			$styles		= runcrew_get_list_templates('events');
			$sorting	= array(
				"event_date"=> esc_html__("Start Date", 'trx_utils'),
				"title" 	=> esc_html__("Alphabetically", 'trx_utils'),
				"random"	=> esc_html__("Random", 'trx_utils')
			);
			$controls	= runcrew_get_list_slider_controls();

			runcrew_sc_map_before('trx_form', "trx_events", array(
					"title" => esc_html__("Events", "runcrew"),
					"desc" => esc_html__("Insert events list in your page (post)", "runcrew"),
					"decorate" => true,
					"container" => false,
					"params" => array(
						"title" => array(
							"title" => esc_html__("Title", "runcrew"),
							"desc" => esc_html__("Title for the block", "runcrew"),
							"value" => "",
							"type" => "text"
						),
						"subtitle" => array(
							"title" => esc_html__("Subtitle", "runcrew"),
							"desc" => esc_html__("Subtitle for the block", "runcrew"),
							"value" => "",
							"type" => "text"
						),
						"description" => array(
							"title" => esc_html__("Description", "runcrew"),
							"desc" => esc_html__("Short description for the block", "runcrew"),
							"value" => "",
							"type" => "textarea"
						),
						"style" => array(
							"title" => esc_html__("Style", "runcrew"),
							"desc" => esc_html__("Select style to display events list", "runcrew"),
							"value" => "events-1",
							"type" => "select",
							"options" => $styles
						),
						"columns" => array(
							"title" => esc_html__("Columns", "runcrew"),
							"desc" => esc_html__("How many columns use to show events list", "runcrew"),
							"value" => 4,
							"min" => 2,
							"max" => 6,
							"step" => 1,
							"type" => "spinner"
						),
						"scheme" => array(
							"title" => esc_html__("Color scheme", "runcrew"),
							"desc" => esc_html__("Select color scheme for this block", "runcrew"),
							"value" => "",
							"type" => "checklist",
							"options" => runcrew_get_sc_param('schemes')
						),
						"slider" => array(
							"title" => esc_html__("Slider", "runcrew"),
							"desc" => esc_html__("Use slider to show events", "runcrew"),
							"dependency" => array(
								'style' => array('events-1')
							),
							"value" => "no",
							"type" => "switch",
							"options" => runcrew_get_sc_param('yes_no')
						),
						"controls" => array(
							"title" => esc_html__("Controls", "runcrew"),
							"desc" => esc_html__("Slider controls style and position", "runcrew"),
							"dependency" => array(
								'slider' => array('yes')
							),
							"divider" => true,
							"value" => "",
							"type" => "checklist",
							"dir" => "horizontal",
							"options" => $controls
						),
						"slides_space" => array(
							"title" => esc_html__("Space between slides", "runcrew"),
							"desc" => esc_html__("Size of space (in px) between slides", "runcrew"),
							"dependency" => array(
								'slider' => array('yes')
							),
							"value" => 0,
							"min" => 0,
							"max" => 100,
							"step" => 10,
							"type" => "spinner"
						),
						"interval" => array(
							"title" => esc_html__("Slides change interval", "runcrew"),
							"desc" => esc_html__("Slides change interval (in milliseconds: 1000ms = 1s)", "runcrew"),
							"dependency" => array(
								'slider' => array('yes')
							),
							"value" => 7000,
							"step" => 500,
							"min" => 0,
							"type" => "spinner"
						),
						"autoheight" => array(
							"title" => esc_html__("Autoheight", "runcrew"),
							"desc" => esc_html__("Change whole slider's height (make it equal current slide's height)", "runcrew"),
							"dependency" => array(
								'slider' => array('yes')
							),
							"value" => "yes",
							"type" => "switch",
							"options" => runcrew_get_sc_param('yes_no')
						),
						"align" => array(
							"title" => esc_html__("Alignment", "runcrew"),
							"desc" => esc_html__("Alignment of the events block", "runcrew"),
							"divider" => true,
							"value" => "",
							"type" => "checklist",
							"dir" => "horizontal",
							"options" => runcrew_get_sc_param('align')
						),
						"cat" => array(
							"title" => esc_html__("Categories", "runcrew"),
							"desc" => esc_html__("Select categories (groups) to show events list. If empty - select events from any category (group) or from IDs list", "runcrew"),
							"divider" => true,
							"value" => "",
							"type" => "select",
							"style" => "list",
							"multiple" => true,
							"options" => runcrew_array_merge(array(0 => esc_html__('- Select category -', 'trx_utils')), $groups)
						),
						"count" => array(
							"title" => esc_html__("Number of posts", "runcrew"),
							"desc" => esc_html__("How many posts will be displayed? If used IDs - this parameter ignored.", "runcrew"),
							"value" => 4,
							"min" => 1,
							"max" => 100,
							"type" => "spinner"
						),
						"offset" => array(
							"title" => esc_html__("Offset before select posts", "runcrew"),
							"desc" => esc_html__("Skip posts before select next part.", "runcrew"),
							"value" => 0,
							"min" => 0,
							"type" => "spinner"
						),
						"orderby" => array(
							"title" => esc_html__("Post order by", "runcrew"),
							"desc" => esc_html__("Select desired posts sorting method", "runcrew"),
							"value" => "title",
							"type" => "select",
							"options" => $sorting
						),
						"order" => array(
							"title" => esc_html__("Post order", "runcrew"),
							"desc" => esc_html__("Select desired posts order", "runcrew"),
							"value" => "asc",
							"type" => "switch",
							"size" => "big",
							"options" => runcrew_get_sc_param('ordering')
						),
						"ids" => array(
							"title" => esc_html__("Post IDs list", "runcrew"),
							"desc" => esc_html__("Comma separated list of posts ID. If set - parameters above are ignored!", "runcrew"),
							"value" => "",
							"type" => "text"
						),
						"readmore" => array(
							"title" => esc_html__("Read more", "runcrew"),
							"desc" => esc_html__("Caption for the Read more link (if empty - link not showed)", "runcrew"),
							"value" => "",
							"type" => "text"
						),
						"link" => array(
							"title" => esc_html__("Button URL", "runcrew"),
							"desc" => esc_html__("Link URL for the button at the bottom of the block", "runcrew"),
							"value" => "",
							"type" => "text"
						),
						"link_caption" => array(
							"title" => esc_html__("Button caption", "runcrew"),
							"desc" => esc_html__("Caption for the button at the bottom of the block", "runcrew"),
							"value" => "",
							"type" => "text"
						),
						"width" => runcrew_shortcodes_width(),
						"height" => runcrew_shortcodes_height(),
						"top" => runcrew_get_sc_param('top'),
						"bottom" => runcrew_get_sc_param('bottom'),
						"left" => runcrew_get_sc_param('left'),
						"right" => runcrew_get_sc_param('right'),
						"id" => runcrew_get_sc_param('id'),
						"class" => runcrew_get_sc_param('class'),
						"animation" => runcrew_get_sc_param('animation'),
						"css" => runcrew_get_sc_param('css')
					)
				)
			);
		}
	}
}


// Add [trx_events] in the VC shortcodes list
if (!function_exists('runcrew_tribe_events_reg_shortcodes_vc')) {
	function runcrew_tribe_events_reg_shortcodes_vc() {

		$groups		= runcrew_get_list_terms(false, Tribe__Events__Main::TAXONOMY);
		$styles		= runcrew_get_list_templates('events');
		$sorting	= array(
			"event_date"=> esc_html__("Start Date", 'trx_utils'),
			"title" 	=> esc_html__("Alphabetically", 'trx_utils'),
			"random"	=> esc_html__("Random", 'trx_utils')
		);
		$controls	= runcrew_get_list_slider_controls();

		// Events
		vc_map( array(
			"base" => "trx_events",
			"name" => esc_html__("Events", "runcrew"),
			"description" => esc_html__("Insert events list", "runcrew"),
			"category" => esc_html__('Content', 'trx_utils'),
			"icon" => 'icon_trx_events',
			"class" => "trx_sc_single trx_sc_events",
			"content_element" => true,
			"is_container" => false,
			"show_settings_on_create" => true,
			"params" => array(
				array(
					"param_name" => "style",
					"heading" => esc_html__("Style", "runcrew"),
					"description" => esc_html__("Select style to display events list", "runcrew"),
					"class" => "",
					"admin_label" => true,
					"std" => "events-1",
					"value" => array_flip($styles),
					"type" => "dropdown"
				),
				array(
					"param_name" => "scheme",
					"heading" => esc_html__("Color scheme", "runcrew"),
					"description" => esc_html__("Select color scheme for this block", "runcrew"),
					"admin_label" => true,
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('schemes')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "slider",
					"heading" => esc_html__("Slider", "runcrew"),
					"description" => esc_html__("Use slider to show events", "runcrew"),
					"admin_label" => true,
					'dependency' => array(
						'element' => 'style',
						'value' => 'events-1'
					),
					"group" => esc_html__('Slider', 'trx_utils'),
					"class" => "",
					"std" => "no",
					"value" => array_flip(runcrew_get_sc_param('yes_no')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "controls",
					"heading" => esc_html__("Controls", "runcrew"),
					"description" => esc_html__("Slider controls style and position", "runcrew"),
					"admin_label" => true,
					"group" => esc_html__('Slider', 'trx_utils'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"std" => "no",
					"value" => array_flip($controls),
					"type" => "dropdown"
				),
				array(
					"param_name" => "slides_space",
					"heading" => esc_html__("Space between slides", "runcrew"),
					"description" => esc_html__("Size of space (in px) between slides", "runcrew"),
					"admin_label" => true,
					"group" => esc_html__('Slider', 'trx_utils'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"value" => "0",
					"type" => "textfield"
				),
				array(
					"param_name" => "interval",
					"heading" => esc_html__("Slides change interval", "runcrew"),
					"description" => esc_html__("Slides change interval (in milliseconds: 1000ms = 1s)", "runcrew"),
					"group" => esc_html__('Slider', 'trx_utils'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"value" => "7000",
					"type" => "textfield"
				),
				array(
					"param_name" => "autoheight",
					"heading" => esc_html__("Autoheight", "runcrew"),
					"description" => esc_html__("Change whole slider's height (make it equal current slide's height)", "runcrew"),
					"group" => esc_html__('Slider', 'trx_utils'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"value" => array("Autoheight" => "yes" ),
					"type" => "checkbox"
				),
				array(
					"param_name" => "align",
					"heading" => esc_html__("Alignment", "runcrew"),
					"description" => esc_html__("Alignment of the events block", "runcrew"),
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('align')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "title",
					"heading" => esc_html__("Title", "runcrew"),
					"description" => esc_html__("Title for the block", "runcrew"),
					"admin_label" => true,
					"group" => esc_html__('Captions', 'trx_utils'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "subtitle",
					"heading" => esc_html__("Subtitle", "runcrew"),
					"description" => esc_html__("Subtitle for the block", "runcrew"),
					"group" => esc_html__('Captions', 'trx_utils'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "description",
					"heading" => esc_html__("Description", "runcrew"),
					"description" => esc_html__("Description for the block", "runcrew"),
					"group" => esc_html__('Captions', 'trx_utils'),
					"class" => "",
					"value" => "",
					"type" => "textarea"
				),
				array(
					"param_name" => "cat",
					"heading" => esc_html__("Categories", "runcrew"),
					"description" => esc_html__("Select category to show events. If empty - select events from any category (group) or from IDs list", "runcrew"),
					"group" => esc_html__('Query', 'trx_utils'),
					"class" => "",
					"value" => array_flip(runcrew_array_merge(array(0 => esc_html__('- Select category -', 'trx_utils')), $groups)),
					"type" => "dropdown"
				),
				array(
					"param_name" => "columns",
					"heading" => esc_html__("Columns", "runcrew"),
					"description" => esc_html__("How many columns use to show events list", "runcrew"),
					"group" => esc_html__('Query', 'trx_utils'),
					"admin_label" => true,
					"class" => "",
					"value" => "4",
					"type" => "textfield"
				),
				array(
					"param_name" => "count",
					"heading" => esc_html__("Number of posts", "runcrew"),
					"description" => esc_html__("How many posts will be displayed? If used IDs - this parameter ignored.", "runcrew"),
					"admin_label" => true,
					"group" => esc_html__('Query', 'trx_utils'),
					"class" => "",
					"value" => "4",
					"type" => "textfield"
				),
				array(
					"param_name" => "offset",
					"heading" => esc_html__("Offset before select posts", "runcrew"),
					"description" => esc_html__("Skip posts before select next part.", "runcrew"),
					"group" => esc_html__('Query', 'trx_utils'),
					"class" => "",
					"value" => "0",
					"type" => "textfield"
				),
				array(
					"param_name" => "orderby",
					"heading" => esc_html__("Post sorting", "runcrew"),
					"description" => esc_html__("Select desired posts sorting method", "runcrew"),
					"group" => esc_html__('Query', 'trx_utils'),
					"class" => "",
					"value" => array_flip($sorting),
					"type" => "dropdown"
				),
				array(
					"param_name" => "order",
					"heading" => esc_html__("Post order", "runcrew"),
					"description" => esc_html__("Select desired posts order", "runcrew"),
					"group" => esc_html__('Query', 'trx_utils'),
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('ordering')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "ids",
					"heading" => esc_html__("Event's IDs list", "runcrew"),
					"description" => esc_html__("Comma separated list of event's ID. If set - parameters above (category, count, order, etc.)  are ignored!", "runcrew"),
					"group" => esc_html__('Query', 'trx_utils'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "readmore",
					"heading" => esc_html__("Read more", "runcrew"),
					"description" => esc_html__("Caption for the Read more link (if empty - link not showed)", "runcrew"),
					"admin_label" => true,
					"group" => esc_html__('Captions', 'trx_utils'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "link",
					"heading" => esc_html__("Button URL", "runcrew"),
					"description" => esc_html__("Link URL for the button at the bottom of the block", "runcrew"),
					"group" => esc_html__('Captions', 'trx_utils'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "link_caption",
					"heading" => esc_html__("Button caption", "runcrew"),
					"description" => esc_html__("Caption for the button at the bottom of the block", "runcrew"),
					"group" => esc_html__('Captions', 'trx_utils'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				runcrew_vc_width(),
				runcrew_vc_height(),
				runcrew_get_vc_param('margin_top'),
				runcrew_get_vc_param('margin_bottom'),
				runcrew_get_vc_param('margin_left'),
				runcrew_get_vc_param('margin_right'),
				runcrew_get_vc_param('id'),
				runcrew_get_vc_param('class'),
				runcrew_get_vc_param('animation'),
				runcrew_get_vc_param('css')
			)
		) );

		class WPBakeryShortCode_Trx_Events extends RUNCREW_VC_ShortCodeSingle {}

	}
}


// Add RevSlider in the shortcodes params
if ( !function_exists( 'runcrew_revslider_shortcodes_params' ) ) {
	//Handler of add_filter( 'runcrew_filter_shortcodes_params',			'runcrew_revslider_shortcodes_params' );
	function runcrew_revslider_shortcodes_params($list=array()) {
		$list["revo_sliders"] = runcrew_get_list_revo_sliders();
		return $list;
	}
}


// Register shortcodes to the internal builder
//------------------------------------------------------------------------
if ( !function_exists( 'runcrew_woocommerce_reg_shortcodes' ) ) {
	function runcrew_woocommerce_reg_shortcodes() {

		// WooCommerce - Cart
		runcrew_sc_map("woocommerce_cart", array(
				"title" => esc_html__("Woocommerce: Cart", 'trx_utils'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: show Cart page", 'trx_utils') ),
				"decorate" => false,
				"container" => false,
				"params" => array()
			)
		);

		// WooCommerce - Checkout
		runcrew_sc_map("woocommerce_checkout", array(
				"title" => esc_html__("Woocommerce: Checkout", 'trx_utils'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: show Checkout page", 'trx_utils') ),
				"decorate" => false,
				"container" => false,
				"params" => array()
			)
		);

		// WooCommerce - My Account
		runcrew_sc_map("woocommerce_my_account", array(
				"title" => esc_html__("Woocommerce: My Account", 'trx_utils'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: show My Account page", 'trx_utils') ),
				"decorate" => false,
				"container" => false,
				"params" => array()
			)
		);

		// WooCommerce - Order Tracking
		runcrew_sc_map("woocommerce_order_tracking", array(
				"title" => esc_html__("Woocommerce: Order Tracking", 'trx_utils'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: show Order Tracking page", 'trx_utils') ),
				"decorate" => false,
				"container" => false,
				"params" => array()
			)
		);

		// WooCommerce - Shop Messages
		runcrew_sc_map("shop_messages", array(
				"title" => esc_html__("Woocommerce: Shop Messages", 'trx_utils'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: show shop messages", 'trx_utils') ),
				"decorate" => false,
				"container" => false,
				"params" => array()
			)
		);

		// WooCommerce - Product Page
		runcrew_sc_map("product_page", array(
				"title" => esc_html__("Woocommerce: Product Page", 'trx_utils'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: display single product page", 'trx_utils') ),
				"decorate" => false,
				"container" => false,
				"params" => array(
					"sku" => array(
						"title" => esc_html__("SKU", 'trx_utils'),
						"desc" => wp_kses_data( __("SKU code of displayed product", 'trx_utils') ),
						"value" => "",
						"type" => "text"
					),
					"id" => array(
						"title" => esc_html__("ID", 'trx_utils'),
						"desc" => wp_kses_data( __("ID of displayed product", 'trx_utils') ),
						"value" => "",
						"type" => "text"
					),
					"posts_per_page" => array(
						"title" => esc_html__("Number", 'trx_utils'),
						"desc" => wp_kses_data( __("How many products showed", 'trx_utils') ),
						"value" => "1",
						"min" => 1,
						"type" => "spinner"
					),
					"post_type" => array(
						"title" => esc_html__("Post type", 'trx_utils'),
						"desc" => wp_kses_data( __("Post type for the WP query (leave 'product')", 'trx_utils') ),
						"value" => "product",
						"type" => "text"
					),
					"post_status" => array(
						"title" => esc_html__("Post status", 'trx_utils'),
						"desc" => wp_kses_data( __("Display posts only with this status", 'trx_utils') ),
						"value" => "publish",
						"type" => "select",
						"options" => array(
							"publish" => esc_html__('Publish', 'trx_utils'),
							"protected" => esc_html__('Protected', 'trx_utils'),
							"private" => esc_html__('Private', 'trx_utils'),
							"pending" => esc_html__('Pending', 'trx_utils'),
							"draft" => esc_html__('Draft', 'trx_utils')
						)
					)
				)
			)
		);

		// WooCommerce - Product
		runcrew_sc_map("product", array(
				"title" => esc_html__("Woocommerce: Product", 'trx_utils'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: display one product", 'trx_utils') ),
				"decorate" => false,
				"container" => false,
				"params" => array(
					"sku" => array(
						"title" => esc_html__("SKU", 'trx_utils'),
						"desc" => wp_kses_data( __("SKU code of displayed product", 'trx_utils') ),
						"value" => "",
						"type" => "text"
					),
					"id" => array(
						"title" => esc_html__("ID", 'trx_utils'),
						"desc" => wp_kses_data( __("ID of displayed product", 'trx_utils') ),
						"value" => "",
						"type" => "text"
					)
				)
			)
		);

		// WooCommerce - Best Selling Products
		runcrew_sc_map("best_selling_products", array(
				"title" => esc_html__("Woocommerce: Best Selling Products", 'trx_utils'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: show best selling products", 'trx_utils') ),
				"decorate" => false,
				"container" => false,
				"params" => array(
					"per_page" => array(
						"title" => esc_html__("Number", 'trx_utils'),
						"desc" => wp_kses_data( __("How many products showed", 'trx_utils') ),
						"value" => 4,
						"min" => 1,
						"type" => "spinner"
					),
					"columns" => array(
						"title" => esc_html__("Columns", 'trx_utils'),
						"desc" => wp_kses_data( __("How many columns per row use for products output", 'trx_utils') ),
						"value" => 4,
						"min" => 2,
						"max" => 4,
						"type" => "spinner"
					)
				)
			)
		);

		// WooCommerce - Recent Products
		runcrew_sc_map("recent_products", array(
				"title" => esc_html__("Woocommerce: Recent Products", 'trx_utils'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: show recent products", 'trx_utils') ),
				"decorate" => false,
				"container" => false,
				"params" => array(
					"per_page" => array(
						"title" => esc_html__("Number", 'trx_utils'),
						"desc" => wp_kses_data( __("How many products showed", 'trx_utils') ),
						"value" => 4,
						"min" => 1,
						"type" => "spinner"
					),
					"columns" => array(
						"title" => esc_html__("Columns", 'trx_utils'),
						"desc" => wp_kses_data( __("How many columns per row use for products output", 'trx_utils') ),
						"value" => 4,
						"min" => 2,
						"max" => 4,
						"type" => "spinner"
					),
					"orderby" => array(
						"title" => esc_html__("Order by", 'trx_utils'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'trx_utils') ),
						"value" => "date",
						"type" => "select",
						"options" => array(
							"date" => esc_html__('Date', 'trx_utils'),
							"title" => esc_html__('Title', 'trx_utils')
						)
					),
					"order" => array(
						"title" => esc_html__("Order", 'trx_utils'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'trx_utils') ),
						"value" => "desc",
						"type" => "switch",
						"size" => "big",
						"options" => runcrew_get_sc_param('ordering')
					)
				)
			)
		);

		// WooCommerce - Related Products
		runcrew_sc_map("related_products", array(
				"title" => esc_html__("Woocommerce: Related Products", 'trx_utils'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: show related products", 'trx_utils') ),
				"decorate" => false,
				"container" => false,
				"params" => array(
					"posts_per_page" => array(
						"title" => esc_html__("Number", 'trx_utils'),
						"desc" => wp_kses_data( __("How many products showed", 'trx_utils') ),
						"value" => 4,
						"min" => 1,
						"type" => "spinner"
					),
					"columns" => array(
						"title" => esc_html__("Columns", 'trx_utils'),
						"desc" => wp_kses_data( __("How many columns per row use for products output", 'trx_utils') ),
						"value" => 4,
						"min" => 2,
						"max" => 4,
						"type" => "spinner"
					),
					"orderby" => array(
						"title" => esc_html__("Order by", 'trx_utils'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'trx_utils') ),
						"value" => "date",
						"type" => "select",
						"options" => array(
							"date" => esc_html__('Date', 'trx_utils'),
							"title" => esc_html__('Title', 'trx_utils')
						)
					)
				)
			)
		);

		// WooCommerce - Featured Products
		runcrew_sc_map("featured_products", array(
				"title" => esc_html__("Woocommerce: Featured Products", 'trx_utils'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: show featured products", 'trx_utils') ),
				"decorate" => false,
				"container" => false,
				"params" => array(
					"per_page" => array(
						"title" => esc_html__("Number", 'trx_utils'),
						"desc" => wp_kses_data( __("How many products showed", 'trx_utils') ),
						"value" => 4,
						"min" => 1,
						"type" => "spinner"
					),
					"columns" => array(
						"title" => esc_html__("Columns", 'trx_utils'),
						"desc" => wp_kses_data( __("How many columns per row use for products output", 'trx_utils') ),
						"value" => 4,
						"min" => 2,
						"max" => 4,
						"type" => "spinner"
					),
					"orderby" => array(
						"title" => esc_html__("Order by", 'trx_utils'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'trx_utils') ),
						"value" => "date",
						"type" => "select",
						"options" => array(
							"date" => esc_html__('Date', 'trx_utils'),
							"title" => esc_html__('Title', 'trx_utils')
						)
					),
					"order" => array(
						"title" => esc_html__("Order", 'runcrew'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"value" => "desc",
						"type" => "switch",
						"size" => "big",
						"options" => runcrew_get_sc_param('ordering')
					)
				)
			)
		);

		// WooCommerce - Top Rated Products
		runcrew_sc_map("featured_products", array(
				"title" => esc_html__("Woocommerce: Top Rated Products", 'runcrew'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: show top rated products", 'runcrew') ),
				"decorate" => false,
				"container" => false,
				"params" => array(
					"per_page" => array(
						"title" => esc_html__("Number", 'runcrew'),
						"desc" => wp_kses_data( __("How many products showed", 'runcrew') ),
						"value" => 4,
						"min" => 1,
						"type" => "spinner"
					),
					"columns" => array(
						"title" => esc_html__("Columns", 'runcrew'),
						"desc" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"value" => 4,
						"min" => 2,
						"max" => 4,
						"type" => "spinner"
					),
					"orderby" => array(
						"title" => esc_html__("Order by", 'runcrew'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"value" => "date",
						"type" => "select",
						"options" => array(
							"date" => esc_html__('Date', 'runcrew'),
							"title" => esc_html__('Title', 'runcrew')
						)
					),
					"order" => array(
						"title" => esc_html__("Order", 'runcrew'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"value" => "desc",
						"type" => "switch",
						"size" => "big",
						"options" => runcrew_get_sc_param('ordering')
					)
				)
			)
		);

		// WooCommerce - Sale Products
		runcrew_sc_map("featured_products", array(
				"title" => esc_html__("Woocommerce: Sale Products", 'runcrew'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: list products on sale", 'runcrew') ),
				"decorate" => false,
				"container" => false,
				"params" => array(
					"per_page" => array(
						"title" => esc_html__("Number", 'runcrew'),
						"desc" => wp_kses_data( __("How many products showed", 'runcrew') ),
						"value" => 4,
						"min" => 1,
						"type" => "spinner"
					),
					"columns" => array(
						"title" => esc_html__("Columns", 'runcrew'),
						"desc" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"value" => 4,
						"min" => 2,
						"max" => 4,
						"type" => "spinner"
					),
					"orderby" => array(
						"title" => esc_html__("Order by", 'runcrew'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"value" => "date",
						"type" => "select",
						"options" => array(
							"date" => esc_html__('Date', 'runcrew'),
							"title" => esc_html__('Title', 'runcrew')
						)
					),
					"order" => array(
						"title" => esc_html__("Order", 'runcrew'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"value" => "desc",
						"type" => "switch",
						"size" => "big",
						"options" => runcrew_get_sc_param('ordering')
					)
				)
			)
		);

		// WooCommerce - Product Category
		runcrew_sc_map("product_category", array(
				"title" => esc_html__("Woocommerce: Products from category", 'runcrew'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: list products in specified category(-ies)", 'runcrew') ),
				"decorate" => false,
				"container" => false,
				"params" => array(
					"per_page" => array(
						"title" => esc_html__("Number", 'runcrew'),
						"desc" => wp_kses_data( __("How many products showed", 'runcrew') ),
						"value" => 4,
						"min" => 1,
						"type" => "spinner"
					),
					"columns" => array(
						"title" => esc_html__("Columns", 'runcrew'),
						"desc" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"value" => 4,
						"min" => 2,
						"max" => 4,
						"type" => "spinner"
					),
					"orderby" => array(
						"title" => esc_html__("Order by", 'runcrew'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"value" => "date",
						"type" => "select",
						"options" => array(
							"date" => esc_html__('Date', 'runcrew'),
							"title" => esc_html__('Title', 'runcrew')
						)
					),
					"order" => array(
						"title" => esc_html__("Order", 'runcrew'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"value" => "desc",
						"type" => "switch",
						"size" => "big",
						"options" => runcrew_get_sc_param('ordering')
					),
					"category" => array(
						"title" => esc_html__("Categories", 'runcrew'),
						"desc" => wp_kses_data( __("Comma separated category slugs", 'runcrew') ),
						"value" => '',
						"type" => "text"
					),
					"operator" => array(
						"title" => esc_html__("Operator", 'runcrew'),
						"desc" => wp_kses_data( __("Categories operator", 'runcrew') ),
						"value" => "IN",
						"type" => "checklist",
						"size" => "medium",
						"options" => array(
							"IN" => esc_html__('IN', 'runcrew'),
							"NOT IN" => esc_html__('NOT IN', 'runcrew'),
							"AND" => esc_html__('AND', 'runcrew')
						)
					)
				)
			)
		);

		// WooCommerce - Products
		runcrew_sc_map("products", array(
				"title" => esc_html__("Woocommerce: Products", 'runcrew'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: list all products", 'runcrew') ),
				"decorate" => false,
				"container" => false,
				"params" => array(
					"skus" => array(
						"title" => esc_html__("SKUs", 'runcrew'),
						"desc" => wp_kses_data( __("Comma separated SKU codes of products", 'runcrew') ),
						"value" => "",
						"type" => "text"
					),
					"ids" => array(
						"title" => esc_html__("IDs", 'runcrew'),
						"desc" => wp_kses_data( __("Comma separated ID of products", 'runcrew') ),
						"value" => "",
						"type" => "text"
					),
					"columns" => array(
						"title" => esc_html__("Columns", 'runcrew'),
						"desc" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"value" => 4,
						"min" => 2,
						"max" => 4,
						"type" => "spinner"
					),
					"orderby" => array(
						"title" => esc_html__("Order by", 'runcrew'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"value" => "date",
						"type" => "select",
						"options" => array(
							"date" => esc_html__('Date', 'runcrew'),
							"title" => esc_html__('Title', 'runcrew')
						)
					),
					"order" => array(
						"title" => esc_html__("Order", 'runcrew'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"value" => "desc",
						"type" => "switch",
						"size" => "big",
						"options" => runcrew_get_sc_param('ordering')
					)
				)
			)
		);

		// WooCommerce - Product attribute
		runcrew_sc_map("product_attribute", array(
				"title" => esc_html__("Woocommerce: Products by Attribute", 'runcrew'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: show products with specified attribute", 'runcrew') ),
				"decorate" => false,
				"container" => false,
				"params" => array(
					"per_page" => array(
						"title" => esc_html__("Number", 'runcrew'),
						"desc" => wp_kses_data( __("How many products showed", 'runcrew') ),
						"value" => 4,
						"min" => 1,
						"type" => "spinner"
					),
					"columns" => array(
						"title" => esc_html__("Columns", 'runcrew'),
						"desc" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"value" => 4,
						"min" => 2,
						"max" => 4,
						"type" => "spinner"
					),
					"orderby" => array(
						"title" => esc_html__("Order by", 'runcrew'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"value" => "date",
						"type" => "select",
						"options" => array(
							"date" => esc_html__('Date', 'runcrew'),
							"title" => esc_html__('Title', 'runcrew')
						)
					),
					"order" => array(
						"title" => esc_html__("Order", 'runcrew'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"value" => "desc",
						"type" => "switch",
						"size" => "big",
						"options" => runcrew_get_sc_param('ordering')
					),
					"attribute" => array(
						"title" => esc_html__("Attribute", 'runcrew'),
						"desc" => wp_kses_data( __("Attribute name", 'runcrew') ),
						"value" => "",
						"type" => "text"
					),
					"filter" => array(
						"title" => esc_html__("Filter", 'runcrew'),
						"desc" => wp_kses_data( __("Attribute value", 'runcrew') ),
						"value" => "",
						"type" => "text"
					)
				)
			)
		);

		// WooCommerce - Products Categories
		runcrew_sc_map("product_categories", array(
				"title" => esc_html__("Woocommerce: Product Categories", 'runcrew'),
				"desc" => wp_kses_data( __("WooCommerce shortcode: show categories with products", 'runcrew') ),
				"decorate" => false,
				"container" => false,
				"params" => array(
					"number" => array(
						"title" => esc_html__("Number", 'runcrew'),
						"desc" => wp_kses_data( __("How many categories showed", 'runcrew') ),
						"value" => 4,
						"min" => 1,
						"type" => "spinner"
					),
					"columns" => array(
						"title" => esc_html__("Columns", 'runcrew'),
						"desc" => wp_kses_data( __("How many columns per row use for categories output", 'runcrew') ),
						"value" => 4,
						"min" => 2,
						"max" => 4,
						"type" => "spinner"
					),
					"orderby" => array(
						"title" => esc_html__("Order by", 'runcrew'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"value" => "date",
						"type" => "select",
						"options" => array(
							"date" => esc_html__('Date', 'runcrew'),
							"title" => esc_html__('Title', 'runcrew')
						)
					),
					"order" => array(
						"title" => esc_html__("Order", 'runcrew'),
						"desc" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"value" => "desc",
						"type" => "switch",
						"size" => "big",
						"options" => runcrew_get_sc_param('ordering')
					),
					"parent" => array(
						"title" => esc_html__("Parent", 'runcrew'),
						"desc" => wp_kses_data( __("Parent category slug", 'runcrew') ),
						"value" => "",
						"type" => "text"
					),
					"ids" => array(
						"title" => esc_html__("IDs", 'runcrew'),
						"desc" => wp_kses_data( __("Comma separated ID of products", 'runcrew') ),
						"value" => "",
						"type" => "text"
					),
					"hide_empty" => array(
						"title" => esc_html__("Hide empty", 'runcrew'),
						"desc" => wp_kses_data( __("Hide empty categories", 'runcrew') ),
						"value" => "yes",
						"type" => "switch",
						"options" => runcrew_get_sc_param('yes_no')
					)
				)
			)
		);
	}
}



// Register shortcodes to the VC builder
//------------------------------------------------------------------------
if ( !function_exists( 'runcrew_woocommerce_reg_shortcodes_vc' ) ) {
	function runcrew_woocommerce_reg_shortcodes_vc() {

		if (false && function_exists('runcrew_exists_woocommerce') && runcrew_exists_woocommerce()) {

			// WooCommerce - Cart
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "woocommerce_cart",
				"name" => esc_html__("Cart", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: show cart page", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_wooc_cart',
				"class" => "trx_sc_alone trx_sc_woocommerce_cart",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => false,
				"params" => array(
					array(
						"param_name" => "dummy",
						"heading" => esc_html__("Dummy data", 'runcrew'),
						"description" => wp_kses_data( __("Dummy data - not used in shortcodes", 'runcrew') ),
						"class" => "",
						"value" => "",
						"type" => "textfield"
					)
				)
			) );

			class WPBakeryShortCode_Woocommerce_Cart extends RUNCREW_VC_ShortCodeAlone {}


			// WooCommerce - Checkout
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "woocommerce_checkout",
				"name" => esc_html__("Checkout", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: show checkout page", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_wooc_checkout',
				"class" => "trx_sc_alone trx_sc_woocommerce_checkout",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => false,
				"params" => array(
					array(
						"param_name" => "dummy",
						"heading" => esc_html__("Dummy data", 'runcrew'),
						"description" => wp_kses_data( __("Dummy data - not used in shortcodes", 'runcrew') ),
						"class" => "",
						"value" => "",
						"type" => "textfield"
					)
				)
			) );

			class WPBakeryShortCode_Woocommerce_Checkout extends RUNCREW_VC_ShortCodeAlone {}


			// WooCommerce - My Account
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "woocommerce_my_account",
				"name" => esc_html__("My Account", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: show my account page", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_wooc_my_account',
				"class" => "trx_sc_alone trx_sc_woocommerce_my_account",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => false,
				"params" => array(
					array(
						"param_name" => "dummy",
						"heading" => esc_html__("Dummy data", 'runcrew'),
						"description" => wp_kses_data( __("Dummy data - not used in shortcodes", 'runcrew') ),
						"class" => "",
						"value" => "",
						"type" => "textfield"
					)
				)
			) );

			class WPBakeryShortCode_Woocommerce_My_Account extends RUNCREW_VC_ShortCodeAlone {}


			// WooCommerce - Order Tracking
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "woocommerce_order_tracking",
				"name" => esc_html__("Order Tracking", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: show order tracking page", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_wooc_order_tracking',
				"class" => "trx_sc_alone trx_sc_woocommerce_order_tracking",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => false,
				"params" => array(
					array(
						"param_name" => "dummy",
						"heading" => esc_html__("Dummy data", 'runcrew'),
						"description" => wp_kses_data( __("Dummy data - not used in shortcodes", 'runcrew') ),
						"class" => "",
						"value" => "",
						"type" => "textfield"
					)
				)
			) );

			class WPBakeryShortCode_Woocommerce_Order_Tracking extends RUNCREW_VC_ShortCodeAlone {}


			// WooCommerce - Shop Messages
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "shop_messages",
				"name" => esc_html__("Shop Messages", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: show shop messages", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_wooc_shop_messages',
				"class" => "trx_sc_alone trx_sc_shop_messages",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => false,
				"params" => array(
					array(
						"param_name" => "dummy",
						"heading" => esc_html__("Dummy data", 'runcrew'),
						"description" => wp_kses_data( __("Dummy data - not used in shortcodes", 'runcrew') ),
						"class" => "",
						"value" => "",
						"type" => "textfield"
					)
				)
			) );

			class WPBakeryShortCode_Shop_Messages extends RUNCREW_VC_ShortCodeAlone {}


			// WooCommerce - Product Page
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "product_page",
				"name" => esc_html__("Product Page", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: display single product page", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_product_page',
				"class" => "trx_sc_single trx_sc_product_page",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => true,
				"params" => array(
					array(
						"param_name" => "sku",
						"heading" => esc_html__("SKU", 'runcrew'),
						"description" => wp_kses_data( __("SKU code of displayed product", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "",
						"type" => "textfield"
					),
					array(
						"param_name" => "id",
						"heading" => esc_html__("ID", 'runcrew'),
						"description" => wp_kses_data( __("ID of displayed product", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "",
						"type" => "textfield"
					),
					array(
						"param_name" => "posts_per_page",
						"heading" => esc_html__("Number", 'runcrew'),
						"description" => wp_kses_data( __("How many products showed", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "1",
						"type" => "textfield"
					),
					array(
						"param_name" => "post_type",
						"heading" => esc_html__("Post type", 'runcrew'),
						"description" => wp_kses_data( __("Post type for the WP query (leave 'product')", 'runcrew') ),
						"class" => "",
						"value" => "product",
						"type" => "textfield"
					),
					array(
						"param_name" => "post_status",
						"heading" => esc_html__("Post status", 'runcrew'),
						"description" => wp_kses_data( __("Display posts only with this status", 'runcrew') ),
						"class" => "",
						"value" => array(
							esc_html__('Publish', 'runcrew') => 'publish',
							esc_html__('Protected', 'runcrew') => 'protected',
							esc_html__('Private', 'runcrew') => 'private',
							esc_html__('Pending', 'runcrew') => 'pending',
							esc_html__('Draft', 'runcrew') => 'draft'
						),
						"type" => "dropdown"
					)
				)
			) );

			class WPBakeryShortCode_Product_Page extends RUNCREW_VC_ShortCodeSingle {}



			// WooCommerce - Product
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "product",
				"name" => esc_html__("Product", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: display one product", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_product',
				"class" => "trx_sc_single trx_sc_product",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => true,
				"params" => array(
					array(
						"param_name" => "sku",
						"heading" => esc_html__("SKU", 'runcrew'),
						"description" => wp_kses_data( __("Product's SKU code", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "",
						"type" => "textfield"
					),
					array(
						"param_name" => "id",
						"heading" => esc_html__("ID", 'runcrew'),
						"description" => wp_kses_data( __("Product's ID", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "",
						"type" => "textfield"
					)
				)
			) );

			class WPBakeryShortCode_Product extends RUNCREW_VC_ShortCodeSingle {}


			// WooCommerce - Best Selling Products
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "best_selling_products",
				"name" => esc_html__("Best Selling Products", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: show best selling products", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_best_selling_products',
				"class" => "trx_sc_single trx_sc_best_selling_products",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => true,
				"params" => array(
					array(
						"param_name" => "per_page",
						"heading" => esc_html__("Number", 'runcrew'),
						"description" => wp_kses_data( __("How many products showed", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "4",
						"type" => "textfield"
					),
					array(
						"param_name" => "columns",
						"heading" => esc_html__("Columns", 'runcrew'),
						"description" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "1",
						"type" => "textfield"
					)
				)
			) );

			class WPBakeryShortCode_Best_Selling_Products extends RUNCREW_VC_ShortCodeSingle {}



			// WooCommerce - Recent Products
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "recent_products",
				"name" => esc_html__("Recent Products", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: show recent products", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_recent_products',
				"class" => "trx_sc_single trx_sc_recent_products",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => true,
				"params" => array(
					array(
						"param_name" => "per_page",
						"heading" => esc_html__("Number", 'runcrew'),
						"description" => wp_kses_data( __("How many products showed", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "4",
						"type" => "textfield"

					),
					array(
						"param_name" => "columns",
						"heading" => esc_html__("Columns", 'runcrew'),
						"description" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "1",
						"type" => "textfield"
					),
					array(
						"param_name" => "orderby",
						"heading" => esc_html__("Order by", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array(
							esc_html__('Date', 'runcrew') => 'date',
							esc_html__('Title', 'runcrew') => 'title'
						),
						"type" => "dropdown"
					),
					array(
						"param_name" => "order",
						"heading" => esc_html__("Order", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array_flip(runcrew_get_sc_param('ordering')),
						"type" => "dropdown"
					)
				)
			) );

			class WPBakeryShortCode_Recent_Products extends RUNCREW_VC_ShortCodeSingle {}



			// WooCommerce - Related Products
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "related_products",
				"name" => esc_html__("Related Products", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: show related products", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_related_products',
				"class" => "trx_sc_single trx_sc_related_products",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => true,
				"params" => array(
					array(
						"param_name" => "posts_per_page",
						"heading" => esc_html__("Number", 'runcrew'),
						"description" => wp_kses_data( __("How many products showed", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "4",
						"type" => "textfield"
					),
					array(
						"param_name" => "columns",
						"heading" => esc_html__("Columns", 'runcrew'),
						"description" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "1",
						"type" => "textfield"
					),
					array(
						"param_name" => "orderby",
						"heading" => esc_html__("Order by", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array(
							esc_html__('Date', 'runcrew') => 'date',
							esc_html__('Title', 'runcrew') => 'title'
						),
						"type" => "dropdown"
					)
				)
			) );

			class WPBakeryShortCode_Related_Products extends RUNCREW_VC_ShortCodeSingle {}



			// WooCommerce - Featured Products
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "featured_products",
				"name" => esc_html__("Featured Products", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: show featured products", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_featured_products',
				"class" => "trx_sc_single trx_sc_featured_products",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => true,
				"params" => array(
					array(
						"param_name" => "per_page",
						"heading" => esc_html__("Number", 'runcrew'),
						"description" => wp_kses_data( __("How many products showed", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "4",
						"type" => "textfield"
					),
					array(
						"param_name" => "columns",
						"heading" => esc_html__("Columns", 'runcrew'),
						"description" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "1",
						"type" => "textfield"
					),
					array(
						"param_name" => "orderby",
						"heading" => esc_html__("Order by", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array(
							esc_html__('Date', 'runcrew') => 'date',
							esc_html__('Title', 'runcrew') => 'title'
						),
						"type" => "dropdown"
					),
					array(
						"param_name" => "order",
						"heading" => esc_html__("Order", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array_flip(runcrew_get_sc_param('ordering')),
						"type" => "dropdown"
					)
				)
			) );

			class WPBakeryShortCode_Featured_Products extends RUNCREW_VC_ShortCodeSingle {}



			// WooCommerce - Top Rated Products
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "top_rated_products",
				"name" => esc_html__("Top Rated Products", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: show top rated products", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_top_rated_products',
				"class" => "trx_sc_single trx_sc_top_rated_products",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => true,
				"params" => array(
					array(
						"param_name" => "per_page",
						"heading" => esc_html__("Number", 'runcrew'),
						"description" => wp_kses_data( __("How many products showed", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "4",
						"type" => "textfield"
					),
					array(
						"param_name" => "columns",
						"heading" => esc_html__("Columns", 'runcrew'),
						"description" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "1",
						"type" => "textfield"
					),
					array(
						"param_name" => "orderby",
						"heading" => esc_html__("Order by", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array(
							esc_html__('Date', 'runcrew') => 'date',
							esc_html__('Title', 'runcrew') => 'title'
						),
						"type" => "dropdown"
					),
					array(
						"param_name" => "order",
						"heading" => esc_html__("Order", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array_flip(runcrew_get_sc_param('ordering')),
						"type" => "dropdown"
					)
				)
			) );

			class WPBakeryShortCode_Top_Rated_Products extends RUNCREW_VC_ShortCodeSingle {}



			// WooCommerce - Sale Products
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "sale_products",
				"name" => esc_html__("Sale Products", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: list products on sale", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_sale_products',
				"class" => "trx_sc_single trx_sc_sale_products",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => true,
				"params" => array(
					array(
						"param_name" => "per_page",
						"heading" => esc_html__("Number", 'runcrew'),
						"description" => wp_kses_data( __("How many products showed", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "4",
						"type" => "textfield"
					),
					array(
						"param_name" => "columns",
						"heading" => esc_html__("Columns", 'runcrew'),
						"description" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "1",
						"type" => "textfield"
					),
					array(
						"param_name" => "orderby",
						"heading" => esc_html__("Order by", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array(
							esc_html__('Date', 'runcrew') => 'date',
							esc_html__('Title', 'runcrew') => 'title'
						),
						"type" => "dropdown"
					),
					array(
						"param_name" => "order",
						"heading" => esc_html__("Order", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array_flip(runcrew_get_sc_param('ordering')),
						"type" => "dropdown"
					)
				)
			) );

			class WPBakeryShortCode_Sale_Products extends RUNCREW_VC_ShortCodeSingle {}



			// WooCommerce - Product Category
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "product_category",
				"name" => esc_html__("Products from category", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: list products in specified category(-ies)", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_product_category',
				"class" => "trx_sc_single trx_sc_product_category",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => true,
				"params" => array(
					array(
						"param_name" => "per_page",
						"heading" => esc_html__("Number", 'runcrew'),
						"description" => wp_kses_data( __("How many products showed", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "4",
						"type" => "textfield"
					),
					array(
						"param_name" => "columns",
						"heading" => esc_html__("Columns", 'runcrew'),
						"description" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "1",
						"type" => "textfield"
					),
					array(
						"param_name" => "orderby",
						"heading" => esc_html__("Order by", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array(
							esc_html__('Date', 'runcrew') => 'date',
							esc_html__('Title', 'runcrew') => 'title'
						),
						"type" => "dropdown"
					),
					array(
						"param_name" => "order",
						"heading" => esc_html__("Order", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array_flip(runcrew_get_sc_param('ordering')),
						"type" => "dropdown"
					),
					array(
						"param_name" => "category",
						"heading" => esc_html__("Categories", 'runcrew'),
						"description" => wp_kses_data( __("Comma separated category slugs", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "",
						"type" => "textfield"
					),
					array(
						"param_name" => "operator",
						"heading" => esc_html__("Operator", 'runcrew'),
						"description" => wp_kses_data( __("Categories operator", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array(
							esc_html__('IN', 'runcrew') => 'IN',
							esc_html__('NOT IN', 'runcrew') => 'NOT IN',
							esc_html__('AND', 'runcrew') => 'AND'
						),
						"type" => "dropdown"
					)
				)
			) );

			class WPBakeryShortCode_Product_Category extends RUNCREW_VC_ShortCodeSingle {}



			// WooCommerce - Products
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "products",
				"name" => esc_html__("Products", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: list all products", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_products',
				"class" => "trx_sc_single trx_sc_products",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => true,
				"params" => array(
					array(
						"param_name" => "skus",
						"heading" => esc_html__("SKUs", 'runcrew'),
						"description" => wp_kses_data( __("Comma separated SKU codes of products", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "",
						"type" => "textfield"
					),
					array(
						"param_name" => "ids",
						"heading" => esc_html__("IDs", 'runcrew'),
						"description" => wp_kses_data( __("Comma separated ID of products", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "",
						"type" => "textfield"
					),
					array(
						"param_name" => "columns",
						"heading" => esc_html__("Columns", 'runcrew'),
						"description" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "1",
						"type" => "textfield"
					),
					array(
						"param_name" => "orderby",
						"heading" => esc_html__("Order by", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array(
							esc_html__('Date', 'runcrew') => 'date',
							esc_html__('Title', 'runcrew') => 'title'
						),
						"type" => "dropdown"
					),
					array(
						"param_name" => "order",
						"heading" => esc_html__("Order", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array_flip(runcrew_get_sc_param('ordering')),
						"type" => "dropdown"
					)
				)
			) );

			class WPBakeryShortCode_Products extends RUNCREW_VC_ShortCodeSingle {}




			// WooCommerce - Product Attribute
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "product_attribute",
				"name" => esc_html__("Products by Attribute", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: show products with specified attribute", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_product_attribute',
				"class" => "trx_sc_single trx_sc_product_attribute",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => true,
				"params" => array(
					array(
						"param_name" => "per_page",
						"heading" => esc_html__("Number", 'runcrew'),
						"description" => wp_kses_data( __("How many products showed", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "4",
						"type" => "textfield"
					),
					array(
						"param_name" => "columns",
						"heading" => esc_html__("Columns", 'runcrew'),
						"description" => wp_kses_data( __("How many columns per row use for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "1",
						"type" => "textfield"
					),
					array(
						"param_name" => "orderby",
						"heading" => esc_html__("Order by", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array(
							esc_html__('Date', 'runcrew') => 'date',
							esc_html__('Title', 'runcrew') => 'title'
						),
						"type" => "dropdown"
					),
					array(
						"param_name" => "order",
						"heading" => esc_html__("Order", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array_flip(runcrew_get_sc_param('ordering')),
						"type" => "dropdown"
					),
					array(
						"param_name" => "attribute",
						"heading" => esc_html__("Attribute", 'runcrew'),
						"description" => wp_kses_data( __("Attribute name", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "",
						"type" => "textfield"
					),
					array(
						"param_name" => "filter",
						"heading" => esc_html__("Filter", 'runcrew'),
						"description" => wp_kses_data( __("Attribute value", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "",
						"type" => "textfield"
					)
				)
			) );

			class WPBakeryShortCode_Product_Attribute extends RUNCREW_VC_ShortCodeSingle {}



			// WooCommerce - Products Categories
			//-------------------------------------------------------------------------------------

			vc_map( array(
				"base" => "product_categories",
				"name" => esc_html__("Product Categories", 'runcrew'),
				"description" => wp_kses_data( __("WooCommerce shortcode: show categories with products", 'runcrew') ),
				"category" => esc_html__('WooCommerce', 'runcrew'),
				'icon' => 'icon_trx_product_categories',
				"class" => "trx_sc_single trx_sc_product_categories",
				"content_element" => true,
				"is_container" => false,
				"show_settings_on_create" => true,
				"params" => array(
					array(
						"param_name" => "number",
						"heading" => esc_html__("Number", 'runcrew'),
						"description" => wp_kses_data( __("How many categories showed", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "4",
						"type" => "textfield"
					),
					array(
						"param_name" => "columns",
						"heading" => esc_html__("Columns", 'runcrew'),
						"description" => wp_kses_data( __("How many columns per row use for categories output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "1",
						"type" => "textfield"
					),
					array(
						"param_name" => "orderby",
						"heading" => esc_html__("Order by", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array(
							esc_html__('Date', 'runcrew') => 'date',
							esc_html__('Title', 'runcrew') => 'title'
						),
						"type" => "dropdown"
					),
					array(
						"param_name" => "order",
						"heading" => esc_html__("Order", 'runcrew'),
						"description" => wp_kses_data( __("Sorting order for products output", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => array_flip(runcrew_get_sc_param('ordering')),
						"type" => "dropdown"
					),
					array(
						"param_name" => "parent",
						"heading" => esc_html__("Parent", 'runcrew'),
						"description" => wp_kses_data( __("Parent category slug", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "date",
						"type" => "textfield"
					),
					array(
						"param_name" => "ids",
						"heading" => esc_html__("IDs", 'runcrew'),
						"description" => wp_kses_data( __("Comma separated ID of products", 'runcrew') ),
						"admin_label" => true,
						"class" => "",
						"value" => "",
						"type" => "textfield"
					),
					array(
						"param_name" => "hide_empty",
						"heading" => esc_html__("Hide empty", 'runcrew'),
						"description" => wp_kses_data( __("Hide empty categories", 'runcrew') ),
						"class" => "",
						"value" => array("Hide empty" => "1" ),
						"type" => "checkbox"
					)
				)
			) );

			class WPBakeryShortCode_Products_Categories extends RUNCREW_VC_ShortCodeSingle {}
		}
	}
}



// ---------------------------------- [trx_team] ---------------------------------------
if ( !function_exists( 'runcrew_sc_team' ) ) {
	function runcrew_sc_team($atts, $content=null){
		if (runcrew_in_shortcode_blogger()) return '';
		extract(runcrew_html_decode(shortcode_atts(array(
			// Individual params
			"style" => "team-1",
			"slider" => "no",
			"controls" => "no",
			"slides_space" => 0,
			"interval" => "",
			"autoheight" => "no",
			"align" => "",
			"custom" => "no",
			"ids" => "",
			"cat" => "",
			"count" => 3,
			"columns" => 3,
			"offset" => "",
			"orderby" => "title",
			"order" => "asc",
			"title" => "",
			"subtitle" => "",
			"description" => "",
			"link_caption" => esc_html__('Learn more', 'runcrew'),
			"link" => '',
			"scheme" => '',
			// Common params
			"id" => "",
			"class" => "",
			"animation" => "",
			"css" => "",
			"width" => "",
			"height" => "",
			"top" => "",
			"bottom" => "",
			"left" => "",
			"right" => ""
		), $atts)));

		if (empty($id)) $id = "sc_team_".str_replace('.', '', mt_rand());
		if (empty($width)) $width = "100%";
		if (!empty($height) && runcrew_param_is_on($autoheight)) $autoheight = "no";
		if (empty($interval)) $interval = mt_rand(5000, 10000);

		$class .= ($class ? ' ' : '') . runcrew_get_css_position_as_classes($top, $right, $bottom, $left);

		$ws = runcrew_get_css_dimensions_from_values($width);
		$hs = runcrew_get_css_dimensions_from_values('', $height);
		$css .= ($hs) . ($ws);

		$count = max(1, (int) $count);
		$columns = max(1, min(12, (int) $columns));
		if (runcrew_param_is_off($custom) && $count < $columns) $columns = $count;

		runcrew_storage_set('sc_team_data', array(
				'id' => $id,
				'style' => $style,
				'columns' => $columns,
				'counter' => 0,
				'slider' => $slider,
				'css_wh' => $ws . $hs
			)
		);

		if (runcrew_param_is_on($slider)) runcrew_enqueue_slider('swiper');

		$output = '<div' . ($id ? ' id="'.esc_attr($id).'_wrap"' : '')
			. ' class="sc_team_wrap'
			. ($scheme && !runcrew_param_is_off($scheme) && !runcrew_param_is_inherit($scheme) ? ' scheme_'.esc_attr($scheme) : '')
			.'">'
			. '<div' . ($id ? ' id="'.esc_attr($id).'"' : '')
			. ' class="sc_team sc_team_style_'.esc_attr($style)
			. ' ' . esc_attr(runcrew_get_template_property($style, 'container_classes'))
			. (!empty($class) ? ' '.esc_attr($class) : '')
			. ($align!='' && $align!='none' ? ' align'.esc_attr($align) : '')
			.'"'
			. ($css!='' ? ' style="'.esc_attr($css).'"' : '')
			. (!runcrew_param_is_off($animation) ? ' data-animation="'.esc_attr(runcrew_get_animation_classes($animation)).'"' : '')
			. '>'
			. (!empty($subtitle) ? '<h6 class="sc_team_subtitle sc_item_subtitle">' . trim(runcrew_strmacros($subtitle)) . '</h6>' : '')
			. (!empty($title) ? '<h2 class="sc_team_title sc_item_title">' . trim(runcrew_strmacros($title)) . '</h2>' : '')
			. (!empty($description) ? '<div class="sc_team_descr sc_item_descr">' . trim(runcrew_strmacros($description)) . '</div>' : '')
			. (runcrew_param_is_on($slider)
				? ('<div class="sc_slider_swiper swiper-slider-container'
					. ' ' . esc_attr(runcrew_get_slider_controls_classes($controls))
					. (runcrew_param_is_on($autoheight) ? ' sc_slider_height_auto' : '')
					. ($hs ? ' sc_slider_height_fixed' : '')
					. '"'
					. (!empty($width) && runcrew_strpos($width, '%')===false ? ' data-old-width="' . esc_attr($width) . '"' : '')
					. (!empty($height) && runcrew_strpos($height, '%')===false ? ' data-old-height="' . esc_attr($height) . '"' : '')
					. ((int) $interval > 0 ? ' data-interval="'.esc_attr($interval).'"' : '')
					. ($slides_space > 0 ? ' data-slides-space="' . esc_attr($slides_space) . '"' : '')
					. ($columns > 1 ? ' data-slides-per-view="' . esc_attr($columns) . '"' : '')
					. ' data-slides-min-width="250"'
					. '>'
					. '<div class="slides swiper-wrapper">')
				: ($columns > 1
					? '<div class="sc_columns columns_wrap">'
					: '')
			);

		$content = do_shortcode($content);

		if (runcrew_param_is_on($custom) && $content) {
			$output .= $content;
		} else {
			global $post;

			if (!empty($ids)) {
				$posts = explode(',', $ids);
				$count = count($posts);
			}

			$args = array(
				'post_type' => 'team',
				'post_status' => 'publish',
				'posts_per_page' => $count,
				'ignore_sticky_posts' => true,
				'order' => $order=='asc' ? 'asc' : 'desc',
			);

			if ($offset > 0 && empty($ids)) {
				$args['offset'] = $offset;
			}

			$args = runcrew_query_add_sort_order($args, $orderby, $order);
			$args = runcrew_query_add_posts_and_cats($args, $ids, 'team', $cat, 'team_group');
			$query = new WP_Query( $args );

			$post_number = 0;

			while ( $query->have_posts() ) {
				$query->the_post();
				$post_number++;
				$args = array(
					'layout' => $style,
					'show' => false,
					'number' => $post_number,
					'posts_on_page' => ($count > 0 ? $count : $query->found_posts),
					"descr" => runcrew_get_custom_option('post_excerpt_maxlength'.($columns > 1 ? '_masonry' : '')),
					"orderby" => $orderby,
					'content' => false,
					'terms_list' => false,
					"columns_count" => $columns,
					'slider' => $slider,
					'tag_id' => $id ? $id . '_' . $post_number : '',
					'tag_class' => '',
					'tag_animation' => '',
					'tag_css' => '',
					'tag_css_wh' => $ws . $hs
				);
				$post_data = runcrew_get_post_data($args);
				$post_meta = get_post_meta($post_data['post_id'], 'runcrew_team_data', true);
				$thumb_sizes = runcrew_get_thumb_sizes(array('layout' => $style));
				$args['position'] = $post_meta['team_member_position'];
				$args['link'] = !empty($post_meta['team_member_link']) ? $post_meta['team_member_link'] : $post_data['post_link'];
				$args['email'] = $post_meta['team_member_email'];
				$args['photo'] = $post_data['post_thumb'];
				$mult = runcrew_get_retina_multiplier();
				if (empty($args['photo']) && !empty($args['email'])) $args['photo'] = get_avatar($args['email'], $thumb_sizes['w']*$mult);
				$args['socials'] = '';
				$soc_list = $post_meta['team_member_socials'];
				if (is_array($soc_list) && count($soc_list)>0) {
					$soc_str = '';
					foreach ($soc_list as $sn=>$sl) {
						if (!empty($sl))
							$soc_str .= (!empty($soc_str) ? '|' : '') . ($sn) . '=' . ($sl);
					}
					if (!empty($soc_str))
						$args['socials'] = runcrew_do_shortcode('[trx_socials size="tiny" shape="round" socials="'.esc_attr($soc_str).'"][/trx_socials]');
				}

				$output .= runcrew_show_post_layout($args, $post_data);
			}
			wp_reset_postdata();
		}

		if (runcrew_param_is_on($slider)) {
			$output .= '</div>'
				. '<div class="sc_slider_controls_wrap"><a class="sc_slider_prev" href="#"></a><a class="sc_slider_next" href="#"></a></div>'
				. '<div class="sc_slider_pagination_wrap"></div>'
				. '</div>';
		} else if ($columns > 1) {
			$output .= '</div>';
		}

		$output .= (!empty($link) ? '<div class="sc_team_button sc_item_button">'.runcrew_do_shortcode('[trx_button link="'.esc_url($link).'" icon="icon-right"]'.esc_html($link_caption).'[/trx_button]').'</div>' : '')
			. '</div><!-- /.sc_team -->'
			. '</div><!-- /.sc_team_wrap -->';

		// Add template specific scripts and styles
		do_action('runcrew_action_blog_scripts', $style);

		return apply_filters('runcrew_shortcode_output', $output, 'trx_team', $atts, $content);
	}
	add_shortcode('trx_team', 'runcrew_sc_team');
}


if ( !function_exists( 'runcrew_sc_team_item' ) ) {
	function runcrew_sc_team_item($atts, $content=null) {
		if (runcrew_in_shortcode_blogger()) return '';
		extract(runcrew_html_decode(shortcode_atts( array(
			// Individual params
			"user" => "",
			"member" => "",
			"name" => "",
			"position" => "",
			"photo" => "",
			"email" => "",
			"link" => "",
			"socials" => "",
			// Common params
			"id" => "",
			"class" => "",
			"animation" => "",
			"css" => ""
		), $atts)));

		runcrew_storage_inc_array('sc_team_data', 'counter');

		$id = $id ? $id : (runcrew_storage_get_array('sc_team_data', 'id') ? runcrew_storage_get_array('sc_team_data', 'id') . '_' . runcrew_storage_get_array('sc_team_data', 'counter') : '');

		$descr = trim(chop(do_shortcode($content)));

		$thumb_sizes = runcrew_get_thumb_sizes(array('layout' => runcrew_storage_get_array('sc_team_data', 'style')));

		if (!empty($socials)) $socials = runcrew_do_shortcode('[trx_socials size="tiny" shape="round" socials="'.esc_attr($socials).'"][/trx_socials]');

		if (!empty($user) && $user!='none' && ($user_obj = get_user_by('login', $user)) != false) {
			$meta = get_user_meta($user_obj->ID);
			if (empty($email))		$email = $user_obj->data->user_email;
			if (empty($name))		$name = $user_obj->data->display_name;
			if (empty($position))	$position = isset($meta['user_position'][0]) ? $meta['user_position'][0] : '';
			if (empty($descr))		$descr = isset($meta['description'][0]) ? $meta['description'][0] : '';
			if (empty($socials))	$socials = runcrew_show_user_socials(array('author_id'=>$user_obj->ID, 'echo'=>false));
		}

		if (!empty($member) && $member!='none' && ($member_obj = (intval($member) > 0 ? get_post($member, OBJECT) : get_page_by_title($member, OBJECT, 'team'))) != null) {
			if (empty($name))		$name = $member_obj->post_title;
			if (empty($descr))		$descr = $member_obj->post_excerpt;
			$post_meta = get_post_meta($member_obj->ID, 'runcrew_team_data', true);
			if (empty($position))	$position = $post_meta['team_member_position'];
			if (empty($link))		$link = !empty($post_meta['team_member_link']) ? $post_meta['team_member_link'] : get_permalink($member_obj->ID);
			if (empty($email))		$email = $post_meta['team_member_email'];
			if (empty($photo)) 		$photo = wp_get_attachment_url(get_post_thumbnail_id($member_obj->ID));
			if (empty($socials)) {
				$socials = '';
				$soc_list = $post_meta['team_member_socials'];
				if (is_array($soc_list) && count($soc_list)>0) {
					$soc_str = '';
					foreach ($soc_list as $sn=>$sl) {
						if (!empty($sl))
							$soc_str .= (!empty($soc_str) ? '|' : '') . ($sn) . '=' . ($sl);
					}
					if (!empty($soc_str))
						$socials = runcrew_do_shortcode('[trx_socials size="tiny" shape="round" socials="'.esc_attr($soc_str).'"][/trx_socials]');
				}
			}
		}
		if (empty($photo)) {
			$mult = runcrew_get_retina_multiplier();
			if (!empty($email)) $photo = get_avatar($email, $thumb_sizes['w']*$mult);
		} else {
			if ($photo > 0) {
				$attach = wp_get_attachment_image_src( $photo, 'full' );
				if (isset($attach[0]) && $attach[0]!='')
					$photo = $attach[0];
			}
			$photo = runcrew_get_resized_image_tag($photo, $thumb_sizes['w'], $thumb_sizes['h']);
		}
		$post_data = array(
			'post_title' => $name,
			'post_excerpt' => $descr
		);
		$args = array(
			'layout' => runcrew_storage_get_array('sc_team_data', 'style'),
			'number' => runcrew_storage_get_array('sc_team_data', 'counter'),
			'columns_count' => runcrew_storage_get_array('sc_team_data', 'columns'),
			'slider' => runcrew_storage_get_array('sc_team_data', 'slider'),
			'show' => false,
			'descr'  => 0,
			'tag_id' => $id,
			'tag_class' => $class,
			'tag_animation' => $animation,
			'tag_css' => $css,
			'tag_css_wh' => runcrew_storage_get_array('sc_team_data', 'css_wh'),
			'position' => $position,
			'link' => $link,
			'email' => $email,
			'photo' => $photo,
			'socials' => $socials
		);
		$output = runcrew_show_post_layout($args, $post_data);

		return apply_filters('runcrew_shortcode_output', $output, 'trx_team_item', $atts, $content);
	}
	add_shortcode('trx_team_item', 'runcrew_sc_team_item');
}
// ---------------------------------- [/trx_team] ---------------------------------------



// Add [trx_team] and [trx_team_item] in the shortcodes list
if (!function_exists('runcrew_team_reg_shortcodes')) {
	function runcrew_team_reg_shortcodes() {
		if (runcrew_storage_isset('shortcodes')) {

			$users = runcrew_get_list_users();
			$members = runcrew_get_list_posts(false, array(
					'post_type'=>'team',
					'orderby'=>'title',
					'order'=>'asc',
					'return'=>'title'
				)
			);
			$team_groups = runcrew_get_list_terms(false, 'team_group');
			$team_styles = runcrew_get_list_templates('team');
			$controls	 = runcrew_get_list_slider_controls();

			runcrew_sc_map_after('trx_tabs', array(

				// Team
				"trx_team" => array(
					"title" => esc_html__("Team", 'runcrew'),
					"desc" => wp_kses_data( __("Insert team in your page (post)", 'runcrew') ),
					"decorate" => true,
					"container" => false,
					"params" => array(
						"title" => array(
							"title" => esc_html__("Title", 'runcrew'),
							"desc" => wp_kses_data( __("Title for the block", 'runcrew') ),
							"value" => "",
							"type" => "text"
						),
						"subtitle" => array(
							"title" => esc_html__("Subtitle", 'runcrew'),
							"desc" => wp_kses_data( __("Subtitle for the block", 'runcrew') ),
							"value" => "",
							"type" => "text"
						),
						"description" => array(
							"title" => esc_html__("Description", 'runcrew'),
							"desc" => wp_kses_data( __("Short description for the block", 'runcrew') ),
							"value" => "",
							"type" => "textarea"
						),
						"style" => array(
							"title" => esc_html__("Team style", 'runcrew'),
							"desc" => wp_kses_data( __("Select style to display team members", 'runcrew') ),
							"value" => "1",
							"type" => "select",
							"options" => $team_styles
						),
						"columns" => array(
							"title" => esc_html__("Columns", 'runcrew'),
							"desc" => wp_kses_data( __("How many columns use to show team members", 'runcrew') ),
							"value" => 3,
							"min" => 2,
							"max" => 5,
							"step" => 1,
							"type" => "spinner"
						),
						"scheme" => array(
							"title" => esc_html__("Color scheme", 'runcrew'),
							"desc" => wp_kses_data( __("Select color scheme for this block", 'runcrew') ),
							"value" => "",
							"type" => "checklist",
							"options" => runcrew_get_sc_param('schemes')
						),
						"slider" => array(
							"title" => esc_html__("Slider", 'runcrew'),
							"desc" => wp_kses_data( __("Use slider to show team members", 'runcrew') ),
							"value" => "no",
							"type" => "switch",
							"options" => runcrew_get_sc_param('yes_no')
						),
						"controls" => array(
							"title" => esc_html__("Controls", 'runcrew'),
							"desc" => wp_kses_data( __("Slider controls style and position", 'runcrew') ),
							"dependency" => array(
								'slider' => array('yes')
							),
							"divider" => true,
							"value" => "",
							"type" => "checklist",
							"dir" => "horizontal",
							"options" => $controls
						),
						"slides_space" => array(
							"title" => esc_html__("Space between slides", 'runcrew'),
							"desc" => wp_kses_data( __("Size of space (in px) between slides", 'runcrew') ),
							"dependency" => array(
								'slider' => array('yes')
							),
							"value" => 0,
							"min" => 0,
							"max" => 100,
							"step" => 10,
							"type" => "spinner"
						),
						"interval" => array(
							"title" => esc_html__("Slides change interval", 'runcrew'),
							"desc" => wp_kses_data( __("Slides change interval (in milliseconds: 1000ms = 1s)", 'runcrew') ),
							"dependency" => array(
								'slider' => array('yes')
							),
							"value" => 7000,
							"step" => 500,
							"min" => 0,
							"type" => "spinner"
						),
						"autoheight" => array(
							"title" => esc_html__("Autoheight", 'runcrew'),
							"desc" => wp_kses_data( __("Change whole slider's height (make it equal current slide's height)", 'runcrew') ),
							"dependency" => array(
								'slider' => array('yes')
							),
							"value" => "yes",
							"type" => "switch",
							"options" => runcrew_get_sc_param('yes_no')
						),
						"align" => array(
							"title" => esc_html__("Alignment", 'runcrew'),
							"desc" => wp_kses_data( __("Alignment of the team block", 'runcrew') ),
							"divider" => true,
							"value" => "",
							"type" => "checklist",
							"dir" => "horizontal",
							"options" => runcrew_get_sc_param('align')
						),
						"custom" => array(
							"title" => esc_html__("Custom", 'runcrew'),
							"desc" => wp_kses_data( __("Allow get team members from inner shortcodes (custom) or get it from specified group (cat)", 'runcrew') ),
							"divider" => true,
							"value" => "no",
							"type" => "switch",
							"options" => runcrew_get_sc_param('yes_no')
						),
						"cat" => array(
							"title" => esc_html__("Categories", 'runcrew'),
							"desc" => wp_kses_data( __("Select categories (groups) to show team members. If empty - select team members from any category (group) or from IDs list", 'runcrew') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"divider" => true,
							"value" => "",
							"type" => "select",
							"style" => "list",
							"multiple" => true,
							"options" => runcrew_array_merge(array(0 => esc_html__('- Select category -', 'runcrew')), $team_groups)
						),
						"count" => array(
							"title" => esc_html__("Number of posts", 'runcrew'),
							"desc" => wp_kses_data( __("How many posts will be displayed? If used IDs - this parameter ignored.", 'runcrew') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => 3,
							"min" => 1,
							"max" => 100,
							"type" => "spinner"
						),
						"offset" => array(
							"title" => esc_html__("Offset before select posts", 'runcrew'),
							"desc" => wp_kses_data( __("Skip posts before select next part.", 'runcrew') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => 0,
							"min" => 0,
							"type" => "spinner"
						),
						"orderby" => array(
							"title" => esc_html__("Post order by", 'runcrew'),
							"desc" => wp_kses_data( __("Select desired posts sorting method", 'runcrew') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => "title",
							"type" => "select",
							"options" => runcrew_get_sc_param('sorting')
						),
						"order" => array(
							"title" => esc_html__("Post order", 'runcrew'),
							"desc" => wp_kses_data( __("Select desired posts order", 'runcrew') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => "asc",
							"type" => "switch",
							"size" => "big",
							"options" => runcrew_get_sc_param('ordering')
						),
						"ids" => array(
							"title" => esc_html__("Post IDs list", 'runcrew'),
							"desc" => wp_kses_data( __("Comma separated list of posts ID. If set - parameters above are ignored!", 'runcrew') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => "",
							"type" => "text"
						),
						"link" => array(
							"title" => esc_html__("Button URL", 'runcrew'),
							"desc" => wp_kses_data( __("Link URL for the button at the bottom of the block", 'runcrew') ),
							"value" => "",
							"type" => "text"
						),
						"link_caption" => array(
							"title" => esc_html__("Button caption", 'runcrew'),
							"desc" => wp_kses_data( __("Caption for the button at the bottom of the block", 'runcrew') ),
							"value" => "",
							"type" => "text"
						),
						"width" => runcrew_shortcodes_width(),
						"height" => runcrew_shortcodes_height(),
						"top" => runcrew_get_sc_param('top'),
						"bottom" => runcrew_get_sc_param('bottom'),
						"left" => runcrew_get_sc_param('left'),
						"right" => runcrew_get_sc_param('right'),
						"id" => runcrew_get_sc_param('id'),
						"class" => runcrew_get_sc_param('class'),
						"animation" => runcrew_get_sc_param('animation'),
						"css" => runcrew_get_sc_param('css')
					),
					"children" => array(
						"name" => "trx_team_item",
						"title" => esc_html__("Member", 'runcrew'),
						"desc" => wp_kses_data( __("Team member", 'runcrew') ),
						"container" => true,
						"params" => array(
							"user" => array(
								"title" => esc_html__("Registerd user", 'runcrew'),
								"desc" => wp_kses_data( __("Select one of registered users (if present) or put name, position, etc. in fields below", 'runcrew') ),
								"value" => "",
								"type" => "select",
								"options" => $users
							),
							"member" => array(
								"title" => esc_html__("Team member", 'runcrew'),
								"desc" => wp_kses_data( __("Select one of team members (if present) or put name, position, etc. in fields below", 'runcrew') ),
								"value" => "",
								"type" => "select",
								"options" => $members
							),
							"link" => array(
								"title" => esc_html__("Link", 'runcrew'),
								"desc" => wp_kses_data( __("Link on team member's personal page", 'runcrew') ),
								"divider" => true,
								"value" => "",
								"type" => "text"
							),
							"name" => array(
								"title" => esc_html__("Name", 'runcrew'),
								"desc" => wp_kses_data( __("Team member's name", 'runcrew') ),
								"divider" => true,
								"dependency" => array(
									'user' => array('is_empty', 'none'),
									'member' => array('is_empty', 'none')
								),
								"value" => "",
								"type" => "text"
							),
							"position" => array(
								"title" => esc_html__("Position", 'runcrew'),
								"desc" => wp_kses_data( __("Team member's position", 'runcrew') ),
								"dependency" => array(
									'user' => array('is_empty', 'none'),
									'member' => array('is_empty', 'none')
								),
								"value" => "",
								"type" => "text"
							),
							"email" => array(
								"title" => esc_html__("E-mail", 'runcrew'),
								"desc" => wp_kses_data( __("Team member's e-mail", 'runcrew') ),
								"dependency" => array(
									'user' => array('is_empty', 'none'),
									'member' => array('is_empty', 'none')
								),
								"value" => "",
								"type" => "text"
							),
							"photo" => array(
								"title" => esc_html__("Photo", 'runcrew'),
								"desc" => wp_kses_data( __("Team member's photo (avatar)", 'runcrew') ),
								"dependency" => array(
									'user' => array('is_empty', 'none'),
									'member' => array('is_empty', 'none')
								),
								"value" => "",
								"readonly" => false,
								"type" => "media"
							),
							"socials" => array(
								"title" => esc_html__("Socials", 'runcrew'),
								"desc" => wp_kses_data( __("Team member's socials icons: name=url|name=url... For example: facebook=http://facebook.com/myaccount|twitter=http://twitter.com/myaccount", 'runcrew') ),
								"dependency" => array(
									'user' => array('is_empty', 'none'),
									'member' => array('is_empty', 'none')
								),
								"value" => "",
								"type" => "text"
							),
							"_content_" => array(
								"title" => esc_html__("Description", 'runcrew'),
								"desc" => wp_kses_data( __("Team member's short description", 'runcrew') ),
								"divider" => true,
								"rows" => 4,
								"value" => "",
								"type" => "textarea"
							),
							"id" => runcrew_get_sc_param('id'),
							"class" => runcrew_get_sc_param('class'),
							"animation" => runcrew_get_sc_param('animation'),
							"css" => runcrew_get_sc_param('css')
						)
					)
				)

			));
		}
	}
}


// Add [trx_team] and [trx_team_item] in the VC shortcodes list
if (!function_exists('runcrew_team_reg_shortcodes_vc')) {
	function runcrew_team_reg_shortcodes_vc() {

		$users = runcrew_get_list_users();
		$members = runcrew_get_list_posts(false, array(
				'post_type'=>'team',
				'orderby'=>'title',
				'order'=>'asc',
				'return'=>'title'
			)
		);
		$team_groups = runcrew_get_list_terms(false, 'team_group');
		$team_styles = runcrew_get_list_templates('team');
		$controls	 = runcrew_get_list_slider_controls();

		// Team
		vc_map( array(
			"base" => "trx_team",
			"name" => esc_html__("Team", 'runcrew'),
			"description" => wp_kses_data( __("Insert team members", 'runcrew') ),
			"category" => esc_html__('Content', 'runcrew'),
			'icon' => 'icon_trx_team',
			"class" => "trx_sc_columns trx_sc_team",
			"content_element" => true,
			"is_container" => true,
			"show_settings_on_create" => true,
			"as_parent" => array('only' => 'trx_team_item'),
			"params" => array(
				array(
					"param_name" => "style",
					"heading" => esc_html__("Team style", 'runcrew'),
					"description" => wp_kses_data( __("Select style to display team members", 'runcrew') ),
					"class" => "",
					"admin_label" => true,
					"value" => array_flip($team_styles),
					"type" => "dropdown"
				),
				array(
					"param_name" => "scheme",
					"heading" => esc_html__("Color scheme", 'runcrew'),
					"description" => wp_kses_data( __("Select color scheme for this block", 'runcrew') ),
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('schemes')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "slider",
					"heading" => esc_html__("Slider", 'runcrew'),
					"description" => wp_kses_data( __("Use slider to show team members", 'runcrew') ),
					"admin_label" => true,
					"group" => esc_html__('Slider', 'runcrew'),
					"class" => "",
					"std" => "no",
					"value" => array_flip(runcrew_get_sc_param('yes_no')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "controls",
					"heading" => esc_html__("Controls", 'runcrew'),
					"description" => wp_kses_data( __("Slider controls style and position", 'runcrew') ),
					"admin_label" => true,
					"group" => esc_html__('Slider', 'runcrew'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"std" => "no",
					"value" => array_flip($controls),
					"type" => "dropdown"
				),
				array(
					"param_name" => "slides_space",
					"heading" => esc_html__("Space between slides", 'runcrew'),
					"description" => wp_kses_data( __("Size of space (in px) between slides", 'runcrew') ),
					"admin_label" => true,
					"group" => esc_html__('Slider', 'runcrew'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"value" => "0",
					"type" => "textfield"
				),
				array(
					"param_name" => "interval",
					"heading" => esc_html__("Slides change interval", 'runcrew'),
					"description" => wp_kses_data( __("Slides change interval (in milliseconds: 1000ms = 1s)", 'runcrew') ),
					"group" => esc_html__('Slider', 'runcrew'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"value" => "7000",
					"type" => "textfield"
				),
				array(
					"param_name" => "autoheight",
					"heading" => esc_html__("Autoheight", 'runcrew'),
					"description" => wp_kses_data( __("Change whole slider's height (make it equal current slide's height)", 'runcrew') ),
					"group" => esc_html__('Slider', 'runcrew'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"value" => array("Autoheight" => "yes" ),
					"type" => "checkbox"
				),
				array(
					"param_name" => "align",
					"heading" => esc_html__("Alignment", 'runcrew'),
					"description" => wp_kses_data( __("Alignment of the team block", 'runcrew') ),
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('align')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "custom",
					"heading" => esc_html__("Custom", 'runcrew'),
					"description" => wp_kses_data( __("Allow get team members from inner shortcodes (custom) or get it from specified group (cat)", 'runcrew') ),
					"class" => "",
					"value" => array("Custom members" => "yes" ),
					"type" => "checkbox"
				),
				array(
					"param_name" => "title",
					"heading" => esc_html__("Title", 'runcrew'),
					"description" => wp_kses_data( __("Title for the block", 'runcrew') ),
					"admin_label" => true,
					"group" => esc_html__('Captions', 'runcrew'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "subtitle",
					"heading" => esc_html__("Subtitle", 'runcrew'),
					"description" => wp_kses_data( __("Subtitle for the block", 'runcrew') ),
					"group" => esc_html__('Captions', 'runcrew'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "description",
					"heading" => esc_html__("Description", 'runcrew'),
					"description" => wp_kses_data( __("Description for the block", 'runcrew') ),
					"group" => esc_html__('Captions', 'runcrew'),
					"class" => "",
					"value" => "",
					"type" => "textarea"
				),
				array(
					"param_name" => "cat",
					"heading" => esc_html__("Categories", 'runcrew'),
					"description" => wp_kses_data( __("Select category to show team members. If empty - select team members from any category (group) or from IDs list", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"class" => "",
					"value" => array_flip(runcrew_array_merge(array(0 => esc_html__('- Select category -', 'runcrew')), $team_groups)),
					"type" => "dropdown"
				),
				array(
					"param_name" => "columns",
					"heading" => esc_html__("Columns", 'runcrew'),
					"description" => wp_kses_data( __("How many columns use to show team members", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					"admin_label" => true,
					"class" => "",
					"value" => "3",
					"type" => "textfield"
				),
				array(
					"param_name" => "count",
					"heading" => esc_html__("Number of posts", 'runcrew'),
					"description" => wp_kses_data( __("How many posts will be displayed? If used IDs - this parameter ignored.", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"class" => "",
					"value" => "3",
					"type" => "textfield"
				),
				array(
					"param_name" => "offset",
					"heading" => esc_html__("Offset before select posts", 'runcrew'),
					"description" => wp_kses_data( __("Skip posts before select next part.", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"class" => "",
					"value" => "0",
					"type" => "textfield"
				),
				array(
					"param_name" => "orderby",
					"heading" => esc_html__("Post sorting", 'runcrew'),
					"description" => wp_kses_data( __("Select desired posts sorting method", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"std" => "title",
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('sorting')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "order",
					"heading" => esc_html__("Post order", 'runcrew'),
					"description" => wp_kses_data( __("Select desired posts order", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"std" => "asc",
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('ordering')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "ids",
					"heading" => esc_html__("Team member's IDs list", 'runcrew'),
					"description" => wp_kses_data( __("Comma separated list of team members's ID. If set - parameters above (category, count, order, etc.)  are ignored!", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "link",
					"heading" => esc_html__("Button URL", 'runcrew'),
					"description" => wp_kses_data( __("Link URL for the button at the bottom of the block", 'runcrew') ),
					"group" => esc_html__('Captions', 'runcrew'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "link_caption",
					"heading" => esc_html__("Button caption", 'runcrew'),
					"description" => wp_kses_data( __("Caption for the button at the bottom of the block", 'runcrew') ),
					"group" => esc_html__('Captions', 'runcrew'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				runcrew_vc_width(),
				runcrew_vc_height(),
				runcrew_get_vc_param('margin_top'),
				runcrew_get_vc_param('margin_bottom'),
				runcrew_get_vc_param('margin_left'),
				runcrew_get_vc_param('margin_right'),
				runcrew_get_vc_param('id'),
				runcrew_get_vc_param('class'),
				runcrew_get_vc_param('animation'),
				runcrew_get_vc_param('css')
			),
			'default_content' => '
					[trx_team_item user="' . esc_html__( 'Member 1', 'runcrew' ) . '"][/trx_team_item]
					[trx_team_item user="' . esc_html__( 'Member 2', 'runcrew' ) . '"][/trx_team_item]
					[trx_team_item user="' . esc_html__( 'Member 4', 'runcrew' ) . '"][/trx_team_item]
				',
			'js_view' => 'VcTrxColumnsView'
		) );


		vc_map( array(
			"base" => "trx_team_item",
			"name" => esc_html__("Team member", 'runcrew'),
			"description" => wp_kses_data( __("Team member - all data pull out from it account on your site", 'runcrew') ),
			"show_settings_on_create" => true,
			"class" => "trx_sc_collection trx_sc_column_item trx_sc_team_item",
			"content_element" => true,
			"is_container" => true,
			'icon' => 'icon_trx_team_item',
			"as_child" => array('only' => 'trx_team'),
			"as_parent" => array('except' => 'trx_team'),
			"params" => array(
				array(
					"param_name" => "user",
					"heading" => esc_html__("Registered user", 'runcrew'),
					"description" => wp_kses_data( __("Select one of registered users (if present) or put name, position, etc. in fields below", 'runcrew') ),
					"admin_label" => true,
					"class" => "",
					"value" => array_flip($users),
					"type" => "dropdown"
				),
				array(
					"param_name" => "member",
					"heading" => esc_html__("Team member", 'runcrew'),
					"description" => wp_kses_data( __("Select one of team members (if present) or put name, position, etc. in fields below", 'runcrew') ),
					"admin_label" => true,
					"class" => "",
					"value" => array_flip($members),
					"type" => "dropdown"
				),
				array(
					"param_name" => "link",
					"heading" => esc_html__("Link", 'runcrew'),
					"description" => wp_kses_data( __("Link on team member's personal page", 'runcrew') ),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "name",
					"heading" => esc_html__("Name", 'runcrew'),
					"description" => wp_kses_data( __("Team member's name", 'runcrew') ),
					"admin_label" => true,
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "position",
					"heading" => esc_html__("Position", 'runcrew'),
					"description" => wp_kses_data( __("Team member's position", 'runcrew') ),
					"admin_label" => true,
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "email",
					"heading" => esc_html__("E-mail", 'runcrew'),
					"description" => wp_kses_data( __("Team member's e-mail", 'runcrew') ),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "photo",
					"heading" => esc_html__("Member's Photo", 'runcrew'),
					"description" => wp_kses_data( __("Team member's photo (avatar)", 'runcrew') ),
					"class" => "",
					"value" => "",
					"type" => "attach_image"
				),
				array(
					"param_name" => "socials",
					"heading" => esc_html__("Socials", 'runcrew'),
					"description" => wp_kses_data( __("Team member's socials icons: name=url|name=url... For example: facebook=http://facebook.com/myaccount|twitter=http://twitter.com/myaccount", 'runcrew') ),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				runcrew_get_vc_param('id'),
				runcrew_get_vc_param('class'),
				runcrew_get_vc_param('animation'),
				runcrew_get_vc_param('css')
			),
			'js_view' => 'VcTrxColumnItemView'
		) );

		class WPBakeryShortCode_Trx_Team extends RUNCREW_VC_ShortCodeColumns {}
		class WPBakeryShortCode_Trx_Team_Item extends RUNCREW_VC_ShortCodeCollection {}

	}
}


// ---------------------------------- [trx_testimonials] ---------------------------------------

if (!function_exists('runcrew_sc_testimonials')) {
	function runcrew_sc_testimonials($atts, $content=null){
		if (runcrew_in_shortcode_blogger()) return '';
		extract(runcrew_html_decode(shortcode_atts(array(
			// Individual params
			"style" => "testimonials-1",
			"columns" => 1,
			"slider" => "yes",
			"slides_space" => 0,
			"controls" => "no",
			"interval" => "",
			"autoheight" => "no",
			"align" => "",
			"custom" => "no",
			"ids" => "",
			"cat" => "",
			"count" => "3",
			"offset" => "",
			"orderby" => "date",
			"order" => "desc",
			"scheme" => "",
			"bg_color" => "",
			"bg_image" => "",
			"bg_overlay" => "",
			"bg_texture" => "",
			"title" => "",
			"subtitle" => "",
			"description" => "",
			// Common params
			"id" => "",
			"class" => "",
			"animation" => "",
			"css" => "",
			"width" => "",
			"height" => "",
			"top" => "",
			"bottom" => "",
			"left" => "",
			"right" => ""
		), $atts)));

		if (empty($id)) $id = "sc_testimonials_".str_replace('.', '', mt_rand());
		if (empty($width)) $width = "100%";
		if (!empty($height) && runcrew_param_is_on($autoheight)) $autoheight = "no";
		if (empty($interval)) $interval = mt_rand(5000, 10000);

		if ($bg_image > 0) {
			$attach = wp_get_attachment_image_src( $bg_image, 'full' );
			if (isset($attach[0]) && $attach[0]!='')
				$bg_image = $attach[0];
		}

		if ($bg_overlay > 0) {
			if ($bg_color=='') $bg_color = runcrew_get_scheme_color('bg');
			$rgb = runcrew_hex2rgb($bg_color);
		}

		$class .= ($class ? ' ' : '') . runcrew_get_css_position_as_classes($top, $right, $bottom, $left);

		$ws = runcrew_get_css_dimensions_from_values($width);
		$hs = runcrew_get_css_dimensions_from_values('', $height);
		$css .= ($hs) . ($ws);

		$count = max(1, (int) $count);
		$columns = max(1, min(12, (int) $columns));
		if (runcrew_param_is_off($custom) && $count < $columns) $columns = $count;

		runcrew_storage_set('sc_testimonials_data', array(
				'id' => $id,
				'style' => $style,
				'columns' => $columns,
				'counter' => 0,
				'slider' => $slider,
				'css_wh' => $ws . $hs
			)
		);

		if (runcrew_param_is_on($slider)) runcrew_enqueue_slider('swiper');

		$output = ($bg_color!='' || $bg_image!='' || $bg_overlay>0 || $bg_texture>0 || runcrew_strlen($bg_texture)>2 || ($scheme && !runcrew_param_is_off($scheme) && !runcrew_param_is_inherit($scheme))
				? '<div class="sc_testimonials_wrap sc_section'
				. ($scheme && !runcrew_param_is_off($scheme) && !runcrew_param_is_inherit($scheme) ? ' scheme_'.esc_attr($scheme) : '')
				. '"'
				.' style="'
				. ($bg_color !== '' && $bg_overlay==0 ? 'background-color:' . esc_attr($bg_color) . ';' : '')
				. ($bg_image !== '' ? 'background-image:url(' . esc_url($bg_image) . ');' : '')
				. '"'
				. (!runcrew_param_is_off($animation) ? ' data-animation="'.esc_attr(runcrew_get_animation_classes($animation)).'"' : '')
				. '>'
				. '<div class="sc_section_overlay'.($bg_texture>0 ? ' texture_bg_'.esc_attr($bg_texture) : '') . '"'
				. ' style="' . ($bg_overlay>0 ? 'background-color:rgba('.(int)$rgb['r'].','.(int)$rgb['g'].','.(int)$rgb['b'].','.min(1, max(0, $bg_overlay)).');' : '')
				. (runcrew_strlen($bg_texture)>2 ? 'background-image:url('.esc_url($bg_texture).');' : '')
				. '"'
				. ($bg_overlay > 0 ? ' data-overlay="'.esc_attr($bg_overlay).'" data-bg_color="'.esc_attr($bg_color).'"' : '')
				. '>'
				: '')
			. '<div' . ($id ? ' id="'.esc_attr($id).'"' : '')
			. ' class="sc_testimonials sc_testimonials_style_'.esc_attr($style)
			. ' ' . esc_attr(runcrew_get_template_property($style, 'container_classes'))
			. (!empty($class) ? ' '.esc_attr($class) : '')
			. ($align!='' && $align!='none' ? ' align'.esc_attr($align) : '')
			. '"'
			. ($bg_color=='' && $bg_image=='' && $bg_overlay==0 && ($bg_texture=='' || $bg_texture=='0') && !runcrew_param_is_off($animation) ? ' data-animation="'.esc_attr(runcrew_get_animation_classes($animation)).'"' : '')
			. ($css!='' ? ' style="'.esc_attr($css).'"' : '')
			. '>'
			. (!empty($subtitle) ? '<h6 class="sc_testimonials_subtitle sc_item_subtitle">' . trim(runcrew_strmacros($subtitle)) . '</h6>' : '')
			. (!empty($title) ? '<h2 class="sc_testimonials_title sc_item_title">' . trim(runcrew_strmacros($title)) . '</h2>' : '')
			. (!empty($description) ? '<div class="sc_testimonials_descr sc_item_descr">' . trim(runcrew_strmacros($description)) . '</div>' : '')
			. (runcrew_param_is_on($slider)
				? ('<div class="sc_slider_swiper swiper-slider-container'
					. ' ' . esc_attr(runcrew_get_slider_controls_classes($controls))
					. (runcrew_param_is_on($autoheight) ? ' sc_slider_height_auto' : '')
					. ($hs ? ' sc_slider_height_fixed' : '')
					. '"'
					. (!empty($width) && runcrew_strpos($width, '%')===false ? ' data-old-width="' . esc_attr($width) . '"' : '')
					. (!empty($height) && runcrew_strpos($height, '%')===false ? ' data-old-height="' . esc_attr($height) . '"' : '')
					. ((int) $interval > 0 ? ' data-interval="'.esc_attr($interval).'"' : '')
					. ($columns > 1 ? ' data-slides-per-view="' . esc_attr($columns) . '"' : '')
					. ($slides_space > 0 ? ' data-slides-space="' . esc_attr($slides_space) . '"' : '')
					. ' data-slides-min-width="250"'
					. '>'
					. '<div class="slides swiper-wrapper">')
				: ($columns > 1
					? '<div class="sc_columns columns_wrap">'
					: '')
			);

		$content = do_shortcode($content);

		if (runcrew_param_is_on($custom) && $content) {
			$output .= $content;
		} else {
			global $post;

			if (!empty($ids)) {
				$posts = explode(',', $ids);
				$count = count($posts);
			}

			$args = array(
				'post_type' => 'testimonial',
				'post_status' => 'publish',
				'posts_per_page' => $count,
				'ignore_sticky_posts' => true,
                'tribe_suppress_query_filters' => true,
                'order' => $order=='asc' ? 'asc' : 'desc',
			);

			if ($offset > 0 && empty($ids)) {
				$args['offset'] = $offset;
			}

			$args = runcrew_query_add_sort_order($args, $orderby, $order);
			$args = runcrew_query_add_posts_and_cats($args, $ids, 'testimonial', $cat, 'testimonial_group');

			$query = new WP_Query( $args );

			$post_number = 0;

			while ( $query->have_posts() ) {
				$query->the_post();
				$post_number++;
				$args = array(
					'layout' => $style,
					'show' => false,
					'number' => $post_number,
					'posts_on_page' => ($count > 0 ? $count : $query->found_posts),
					"descr" => runcrew_get_custom_option('post_excerpt_maxlength'.($columns > 1 ? '_masonry' : '')),
					"orderby" => $orderby,
					'content' => false,
					'terms_list' => false,
					'columns_count' => $columns,
					'slider' => $slider,
					'tag_id' => $id ? $id . '_' . $post_number : '',
					'tag_class' => '',
					'tag_animation' => '',
					'tag_css' => '',
					'tag_css_wh' => $ws . $hs
				);
				$post_data = runcrew_get_post_data($args);
				$post_data['post_content'] = wpautop($post_data['post_content']);	// Add <p> around text and paragraphs. Need separate call because 'content'=>false (see above)
				$post_meta = get_post_meta($post_data['post_id'], 'runcrew_testimonial_data', true);
				$thumb_sizes = runcrew_get_thumb_sizes(array('layout' => $style));
				$args['author'] = $post_meta['testimonial_author'];
				$args['position'] = $post_meta['testimonial_position'];
				$args['link'] = !empty($post_meta['testimonial_link']) ? $post_meta['testimonial_link'] : '';
				$args['email'] = $post_meta['testimonial_email'];
				$args['photo'] = $post_data['post_thumb'];
				$mult = runcrew_get_retina_multiplier();
				if (empty($args['photo']) && !empty($args['email'])) $args['photo'] = get_avatar($args['email'], $thumb_sizes['w']*$mult);
				$output .= runcrew_show_post_layout($args, $post_data);
			}
			wp_reset_postdata();
		}

		if (runcrew_param_is_on($slider)) {
			$output .= '</div>'
				. '<div class="sc_slider_controls_wrap"><a class="sc_slider_prev" href="#"></a><a class="sc_slider_next" href="#"></a></div>'
				. '<div class="sc_slider_pagination_wrap"></div>'
				. '</div>';
		} else if ($columns > 1) {
			$output .= '</div>';
		}

		$output .= '</div>'
			. ($bg_color!='' || $bg_image!='' || $bg_overlay>0 || $bg_texture>0 || runcrew_strlen($bg_texture)>2
				?  '</div></div>'
				: '');

		// Add template specific scripts and styles
		do_action('runcrew_action_blog_scripts', $style);

		return apply_filters('runcrew_shortcode_output', $output, 'trx_testimonials', $atts, $content);
	}
	add_shortcode('trx_testimonials', 'runcrew_sc_testimonials');
}


if (!function_exists('runcrew_sc_testimonials_item')) {
	function runcrew_sc_testimonials_item($atts, $content=null){
		if (runcrew_in_shortcode_blogger()) return '';
		extract(runcrew_html_decode(shortcode_atts(array(
			// Individual params
			"author" => "",
			"position" => "",
			"link" => "",
			"photo" => "",
			"email" => "",
			// Common params
			"id" => "",
			"class" => "",
			"css" => "",
		), $atts)));

		runcrew_storage_inc_array('sc_testimonials_data', 'counter');

		$id = $id ? $id : (runcrew_storage_get_array('sc_testimonials_data', 'id') ? runcrew_storage_get_array('sc_testimonials_data', 'id') . '_' . runcrew_storage_get_array('sc_testimonials_data', 'counter') : '');

		$thumb_sizes = runcrew_get_thumb_sizes(array('layout' => runcrew_storage_get_array('sc_testimonials_data', 'style')));

		if (empty($photo)) {
			if (!empty($email))
				$mult = '';
			$mult = runcrew_get_retina_multiplier();
			$photo = get_avatar($email, $thumb_sizes['w']*$mult);
		} else {
			if ($photo > 0) {
				$attach = wp_get_attachment_image_src( $photo, 'full' );
				if (isset($attach[0]) && $attach[0]!='')
					$photo = $attach[0];
			}
			$photo = runcrew_get_resized_image_tag($photo, $thumb_sizes['w'], $thumb_sizes['h']);
		}

		$post_data = array(
			'post_content' => do_shortcode($content)
		);
		$args = array(
			'layout' => runcrew_storage_get_array('sc_testimonials_data', 'style'),
			'number' => runcrew_storage_get_array('sc_testimonials_data', 'counter'),
			'columns_count' => runcrew_storage_get_array('sc_testimonials_data', 'columns'),
			'slider' => runcrew_storage_get_array('sc_testimonials_data', 'slider'),
			'show' => false,
			'descr'  => 0,
			'tag_id' => $id,
			'tag_class' => $class,
			'tag_animation' => '',
			'tag_css' => $css,
			'tag_css_wh' => runcrew_storage_get_array('sc_testimonials_data', 'css_wh'),
			'author' => $author,
			'position' => $position,
			'link' => $link,
			'email' => $email,
			'photo' => $photo
		);
		$output = runcrew_show_post_layout($args, $post_data);

		return apply_filters('runcrew_shortcode_output', $output, 'trx_testimonials_item', $atts, $content);
	}
	add_shortcode('trx_testimonials_item', 'runcrew_sc_testimonials_item');
}
// ---------------------------------- [/trx_testimonials] ---------------------------------------



// Add [trx_testimonials] and [trx_testimonials_item] in the shortcodes list
if (!function_exists('runcrew_testimonials_reg_shortcodes')) {
	function runcrew_testimonials_reg_shortcodes() {
		if (runcrew_storage_isset('shortcodes')) {

			$testimonials_groups = runcrew_get_list_terms(false, 'testimonial_group');
			$testimonials_styles = runcrew_get_list_templates('testimonials');
			$controls = runcrew_get_list_slider_controls();

			runcrew_sc_map_before('trx_title', array(

				// Testimonials
				"trx_testimonials" => array(
					"title" => esc_html__("Testimonials", 'runcrew'),
					"desc" => wp_kses_data( __("Insert testimonials into post (page)", 'runcrew') ),
					"decorate" => true,
					"container" => false,
					"params" => array(
						"title" => array(
							"title" => esc_html__("Title", 'runcrew'),
							"desc" => wp_kses_data( __("Title for the block", 'runcrew') ),
							"value" => "",
							"type" => "text"
						),
						"subtitle" => array(
							"title" => esc_html__("Subtitle", 'runcrew'),
							"desc" => wp_kses_data( __("Subtitle for the block", 'runcrew') ),
							"value" => "",
							"type" => "text"
						),
						"description" => array(
							"title" => esc_html__("Description", 'runcrew'),
							"desc" => wp_kses_data( __("Short description for the block", 'runcrew') ),
							"value" => "",
							"type" => "textarea"
						),
						"style" => array(
							"title" => esc_html__("Testimonials style", 'runcrew'),
							"desc" => wp_kses_data( __("Select style to display testimonials", 'runcrew') ),
							"value" => "testimonials-1",
							"type" => "select",
							"options" => $testimonials_styles
						),
						"columns" => array(
							"title" => esc_html__("Columns", 'runcrew'),
							"desc" => wp_kses_data( __("How many columns use to show testimonials", 'runcrew') ),
							"value" => 1,
							"min" => 1,
							"max" => 6,
							"step" => 1,
							"type" => "spinner"
						),
						"slider" => array(
							"title" => esc_html__("Slider", 'runcrew'),
							"desc" => wp_kses_data( __("Use slider to show testimonials", 'runcrew') ),
							"value" => "yes",
							"type" => "switch",
							"options" => runcrew_get_sc_param('yes_no')
						),
						"controls" => array(
							"title" => esc_html__("Controls", 'runcrew'),
							"desc" => wp_kses_data( __("Slider controls style and position", 'runcrew') ),
							"dependency" => array(
								'slider' => array('yes')
							),
							"divider" => true,
							"value" => "",
							"type" => "checklist",
							"dir" => "horizontal",
							"options" => $controls
						),
						"slides_space" => array(
							"title" => esc_html__("Space between slides", 'runcrew'),
							"desc" => wp_kses_data( __("Size of space (in px) between slides", 'runcrew') ),
							"dependency" => array(
								'slider' => array('yes')
							),
							"value" => 0,
							"min" => 0,
							"max" => 100,
							"step" => 10,
							"type" => "spinner"
						),
						"interval" => array(
							"title" => esc_html__("Slides change interval", 'runcrew'),
							"desc" => wp_kses_data( __("Slides change interval (in milliseconds: 1000ms = 1s)", 'runcrew') ),
							"dependency" => array(
								'slider' => array('yes')
							),
							"value" => 7000,
							"step" => 500,
							"min" => 0,
							"type" => "spinner"
						),
						"autoheight" => array(
							"title" => esc_html__("Autoheight", 'runcrew'),
							"desc" => wp_kses_data( __("Change whole slider's height (make it equal current slide's height)", 'runcrew') ),
							"dependency" => array(
								'slider' => array('yes')
							),
							"value" => "yes",
							"type" => "switch",
							"options" => runcrew_get_sc_param('yes_no')
						),
						"align" => array(
							"title" => esc_html__("Alignment", 'runcrew'),
							"desc" => wp_kses_data( __("Alignment of the testimonials block", 'runcrew') ),
							"divider" => true,
							"value" => "",
							"type" => "checklist",
							"dir" => "horizontal",
							"options" => runcrew_get_sc_param('align')
						),
						"custom" => array(
							"title" => esc_html__("Custom", 'runcrew'),
							"desc" => wp_kses_data( __("Allow get testimonials from inner shortcodes (custom) or get it from specified group (cat)", 'runcrew') ),
							"divider" => true,
							"value" => "no",
							"type" => "switch",
							"options" => runcrew_get_sc_param('yes_no')
						),
						"cat" => array(
							"title" => esc_html__("Categories", 'runcrew'),
							"desc" => wp_kses_data( __("Select categories (groups) to show testimonials. If empty - select testimonials from any category (group) or from IDs list", 'runcrew') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"divider" => true,
							"value" => "",
							"type" => "select",
							"style" => "list",
							"multiple" => true,
							"options" => runcrew_array_merge(array(0 => esc_html__('- Select category -', 'runcrew')), $testimonials_groups)
						),
						"count" => array(
							"title" => esc_html__("Number of posts", 'runcrew'),
							"desc" => wp_kses_data( __("How many posts will be displayed? If used IDs - this parameter ignored.", 'runcrew') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => 3,
							"min" => 1,
							"max" => 100,
							"type" => "spinner"
						),
						"offset" => array(
							"title" => esc_html__("Offset before select posts", 'runcrew'),
							"desc" => wp_kses_data( __("Skip posts before select next part.", 'runcrew') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => 0,
							"min" => 0,
							"type" => "spinner"
						),
						"orderby" => array(
							"title" => esc_html__("Post order by", 'runcrew'),
							"desc" => wp_kses_data( __("Select desired posts sorting method", 'runcrew') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => "date",
							"type" => "select",
							"options" => runcrew_get_sc_param('sorting')
						),
						"order" => array(
							"title" => esc_html__("Post order", 'runcrew'),
							"desc" => wp_kses_data( __("Select desired posts order", 'runcrew') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => "desc",
							"type" => "switch",
							"size" => "big",
							"options" => runcrew_get_sc_param('ordering')
						),
						"ids" => array(
							"title" => esc_html__("Post IDs list", 'runcrew'),
							"desc" => wp_kses_data( __("Comma separated list of posts ID. If set - parameters above are ignored!", 'runcrew') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => "",
							"type" => "text"
						),
						"scheme" => array(
							"title" => esc_html__("Color scheme", 'runcrew'),
							"desc" => wp_kses_data( __("Select color scheme for this block", 'runcrew') ),
							"value" => "",
							"type" => "checklist",
							"options" => runcrew_get_sc_param('schemes')
						),
						"bg_color" => array(
							"title" => esc_html__("Background color", 'runcrew'),
							"desc" => wp_kses_data( __("Any background color for this section", 'runcrew') ),
							"value" => "",
							"type" => "color"
						),
						"bg_image" => array(
							"title" => esc_html__("Background image URL", 'runcrew'),
							"desc" => wp_kses_data( __("Select or upload image or write URL from other site for the background", 'runcrew') ),
							"readonly" => false,
							"value" => "",
							"type" => "media"
						),
						"bg_overlay" => array(
							"title" => esc_html__("Overlay", 'runcrew'),
							"desc" => wp_kses_data( __("Overlay color opacity (from 0.0 to 1.0)", 'runcrew') ),
							"min" => "0",
							"max" => "1",
							"step" => "0.1",
							"value" => "0",
							"type" => "spinner"
						),
						"bg_texture" => array(
							"title" => esc_html__("Texture", 'runcrew'),
							"desc" => wp_kses_data( __("Predefined texture style from 1 to 11. 0 - without texture.", 'runcrew') ),
							"min" => "0",
							"max" => "11",
							"step" => "1",
							"value" => "0",
							"type" => "spinner"
						),
						"width" => runcrew_shortcodes_width(),
						"height" => runcrew_shortcodes_height(),
						"top" => runcrew_get_sc_param('top'),
						"bottom" => runcrew_get_sc_param('bottom'),
						"left" => runcrew_get_sc_param('left'),
						"right" => runcrew_get_sc_param('right'),
						"id" => runcrew_get_sc_param('id'),
						"class" => runcrew_get_sc_param('class'),
						"animation" => runcrew_get_sc_param('animation'),
						"css" => runcrew_get_sc_param('css')
					),
					"children" => array(
						"name" => "trx_testimonials_item",
						"title" => esc_html__("Item", 'runcrew'),
						"desc" => wp_kses_data( __("Testimonials item (custom parameters)", 'runcrew') ),
						"container" => true,
						"params" => array(
							"author" => array(
								"title" => esc_html__("Author", 'runcrew'),
								"desc" => wp_kses_data( __("Name of the testimonmials author", 'runcrew') ),
								"value" => "",
								"type" => "text"
							),
							"link" => array(
								"title" => esc_html__("Link", 'runcrew'),
								"desc" => wp_kses_data( __("Link URL to the testimonmials author page", 'runcrew') ),
								"value" => "",
								"type" => "text"
							),
							"email" => array(
								"title" => esc_html__("E-mail", 'runcrew'),
								"desc" => wp_kses_data( __("E-mail of the testimonmials author (to get gravatar)", 'runcrew') ),
								"value" => "",
								"type" => "text"
							),
							"photo" => array(
								"title" => esc_html__("Photo", 'runcrew'),
								"desc" => wp_kses_data( __("Select or upload photo of testimonmials author or write URL of photo from other site", 'runcrew') ),
								"value" => "",
								"type" => "media"
							),
							"_content_" => array(
								"title" => esc_html__("Testimonials text", 'runcrew'),
								"desc" => wp_kses_data( __("Current testimonials text", 'runcrew') ),
								"divider" => true,
								"rows" => 4,
								"value" => "",
								"type" => "textarea"
							),
							"id" => runcrew_get_sc_param('id'),
							"class" => runcrew_get_sc_param('class'),
							"css" => runcrew_get_sc_param('css')
						)
					)
				)

			));
		}
	}
}


// Add [trx_testimonials] and [trx_testimonials_item] in the VC shortcodes list
if (!function_exists('runcrew_testimonials_reg_shortcodes_vc')) {
	function runcrew_testimonials_reg_shortcodes_vc() {

		$testimonials_groups = runcrew_get_list_terms(false, 'testimonial_group');
		$testimonials_styles = runcrew_get_list_templates('testimonials');
		$controls			 = runcrew_get_list_slider_controls();

		// Testimonials
		vc_map( array(
			"base" => "trx_testimonials",
			"name" => esc_html__("Testimonials", 'runcrew'),
			"description" => wp_kses_data( __("Insert testimonials slider", 'runcrew') ),
			"category" => esc_html__('Content', 'runcrew'),
			'icon' => 'icon_trx_testimonials',
			"class" => "trx_sc_columns trx_sc_testimonials",
			"content_element" => true,
			"is_container" => true,
			"show_settings_on_create" => true,
			"as_parent" => array('only' => 'trx_testimonials_item'),
			"params" => array(
				array(
					"param_name" => "style",
					"heading" => esc_html__("Testimonials style", 'runcrew'),
					"description" => wp_kses_data( __("Select style to display testimonials", 'runcrew') ),
					"class" => "",
					"admin_label" => true,
					"value" => array_flip($testimonials_styles),
					"type" => "dropdown"
				),
				array(
					"param_name" => "slider",
					"heading" => esc_html__("Slider", 'runcrew'),
					"description" => wp_kses_data( __("Use slider to show testimonials", 'runcrew') ),
					"admin_label" => true,
					"group" => esc_html__('Slider', 'runcrew'),
					"class" => "",
					"std" => "yes",
					"value" => array_flip(runcrew_get_sc_param('yes_no')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "controls",
					"heading" => esc_html__("Controls", 'runcrew'),
					"description" => wp_kses_data( __("Slider controls style and position", 'runcrew') ),
					"admin_label" => true,
					"group" => esc_html__('Slider', 'runcrew'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"std" => "no",
					"value" => array_flip($controls),
					"type" => "dropdown"
				),
				array(
					"param_name" => "slides_space",
					"heading" => esc_html__("Space between slides", 'runcrew'),
					"description" => wp_kses_data( __("Size of space (in px) between slides", 'runcrew') ),
					"admin_label" => true,
					"group" => esc_html__('Slider', 'runcrew'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"value" => "0",
					"type" => "textfield"
				),
				array(
					"param_name" => "interval",
					"heading" => esc_html__("Slides change interval", 'runcrew'),
					"description" => wp_kses_data( __("Slides change interval (in milliseconds: 1000ms = 1s)", 'runcrew') ),
					"group" => esc_html__('Slider', 'runcrew'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"value" => "7000",
					"type" => "textfield"
				),
				array(
					"param_name" => "autoheight",
					"heading" => esc_html__("Autoheight", 'runcrew'),
					"description" => wp_kses_data( __("Change whole slider's height (make it equal current slide's height)", 'runcrew') ),
					"group" => esc_html__('Slider', 'runcrew'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"value" => array("Autoheight" => "yes" ),
					"type" => "checkbox"
				),
				array(
					"param_name" => "align",
					"heading" => esc_html__("Alignment", 'runcrew'),
					"description" => wp_kses_data( __("Alignment of the testimonials block", 'runcrew') ),
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('align')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "custom",
					"heading" => esc_html__("Custom", 'runcrew'),
					"description" => wp_kses_data( __("Allow get testimonials from inner shortcodes (custom) or get it from specified group (cat)", 'runcrew') ),
					"class" => "",
					"value" => array("Custom slides" => "yes" ),
					"type" => "checkbox"
				),
				array(
					"param_name" => "title",
					"heading" => esc_html__("Title", 'runcrew'),
					"description" => wp_kses_data( __("Title for the block", 'runcrew') ),
					"admin_label" => true,
					"group" => esc_html__('Captions', 'runcrew'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "subtitle",
					"heading" => esc_html__("Subtitle", 'runcrew'),
					"description" => wp_kses_data( __("Subtitle for the block", 'runcrew') ),
					"group" => esc_html__('Captions', 'runcrew'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "description",
					"heading" => esc_html__("Description", 'runcrew'),
					"description" => wp_kses_data( __("Description for the block", 'runcrew') ),
					"group" => esc_html__('Captions', 'runcrew'),
					"class" => "",
					"value" => "",
					"type" => "textarea"
				),
				array(
					"param_name" => "cat",
					"heading" => esc_html__("Categories", 'runcrew'),
					"description" => wp_kses_data( __("Select categories (groups) to show testimonials. If empty - select testimonials from any category (group) or from IDs list", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"class" => "",
					"value" => array_flip(runcrew_array_merge(array(0 => esc_html__('- Select category -', 'runcrew')), $testimonials_groups)),
					"type" => "dropdown"
				),
				array(
					"param_name" => "columns",
					"heading" => esc_html__("Columns", 'runcrew'),
					"description" => wp_kses_data( __("How many columns use to show testimonials", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					"admin_label" => true,
					"class" => "",
					"value" => "1",
					"type" => "textfield"
				),
				array(
					"param_name" => "count",
					"heading" => esc_html__("Number of posts", 'runcrew'),
					"description" => wp_kses_data( __("How many posts will be displayed? If used IDs - this parameter ignored.", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"class" => "",
					"value" => "3",
					"type" => "textfield"
				),
				array(
					"param_name" => "offset",
					"heading" => esc_html__("Offset before select posts", 'runcrew'),
					"description" => wp_kses_data( __("Skip posts before select next part.", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"class" => "",
					"value" => "0",
					"type" => "textfield"
				),
				array(
					"param_name" => "orderby",
					"heading" => esc_html__("Post sorting", 'runcrew'),
					"description" => wp_kses_data( __("Select desired posts sorting method", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"std" => "date",
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('sorting')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "order",
					"heading" => esc_html__("Post order", 'runcrew'),
					"description" => wp_kses_data( __("Select desired posts order", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"std" => "desc",
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('ordering')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "ids",
					"heading" => esc_html__("Post IDs list", 'runcrew'),
					"description" => wp_kses_data( __("Comma separated list of posts ID. If set - parameters above are ignored!", 'runcrew') ),
					"group" => esc_html__('Query', 'runcrew'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "scheme",
					"heading" => esc_html__("Color scheme", 'runcrew'),
					"description" => wp_kses_data( __("Select color scheme for this block", 'runcrew') ),
					"group" => esc_html__('Colors and Images', 'runcrew'),
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('schemes')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "bg_color",
					"heading" => esc_html__("Background color", 'runcrew'),
					"description" => wp_kses_data( __("Any background color for this section", 'runcrew') ),
					"group" => esc_html__('Colors and Images', 'runcrew'),
					"class" => "",
					"value" => "",
					"type" => "colorpicker"
				),
				array(
					"param_name" => "bg_image",
					"heading" => esc_html__("Background image URL", 'runcrew'),
					"description" => wp_kses_data( __("Select background image from library for this section", 'runcrew') ),
					"group" => esc_html__('Colors and Images', 'runcrew'),
					"class" => "",
					"value" => "",
					"type" => "attach_image"
				),
				array(
					"param_name" => "bg_overlay",
					"heading" => esc_html__("Overlay", 'runcrew'),
					"description" => wp_kses_data( __("Overlay color opacity (from 0.0 to 1.0)", 'runcrew') ),
					"group" => esc_html__('Colors and Images', 'runcrew'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "bg_texture",
					"heading" => esc_html__("Texture", 'runcrew'),
					"description" => wp_kses_data( __("Texture style from 1 to 11. Empty or 0 - without texture.", 'runcrew') ),
					"group" => esc_html__('Colors and Images', 'runcrew'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				runcrew_vc_width(),
				runcrew_vc_height(),
				runcrew_get_vc_param('margin_top'),
				runcrew_get_vc_param('margin_bottom'),
				runcrew_get_vc_param('margin_left'),
				runcrew_get_vc_param('margin_right'),
				runcrew_get_vc_param('id'),
				runcrew_get_vc_param('class'),
				runcrew_get_vc_param('animation'),
				runcrew_get_vc_param('css')
			),
			'js_view' => 'VcTrxColumnsView'
		) );


		vc_map( array(
			"base" => "trx_testimonials_item",
			"name" => esc_html__("Testimonial", 'runcrew'),
			"description" => wp_kses_data( __("Single testimonials item", 'runcrew') ),
			"show_settings_on_create" => true,
			"class" => "trx_sc_collection trx_sc_column_item trx_sc_testimonials_item",
			"content_element" => true,
			"is_container" => true,
			'icon' => 'icon_trx_testimonials_item',
			"as_child" => array('only' => 'trx_testimonials'),
			"as_parent" => array('except' => 'trx_testimonials'),
			"params" => array(
				array(
					"param_name" => "author",
					"heading" => esc_html__("Author", 'runcrew'),
					"description" => wp_kses_data( __("Name of the testimonmials author", 'runcrew') ),
					"admin_label" => true,
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "link",
					"heading" => esc_html__("Link", 'runcrew'),
					"description" => wp_kses_data( __("Link URL to the testimonmials author page", 'runcrew') ),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "email",
					"heading" => esc_html__("E-mail", 'runcrew'),
					"description" => wp_kses_data( __("E-mail of the testimonmials author", 'runcrew') ),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "photo",
					"heading" => esc_html__("Photo", 'runcrew'),
					"description" => wp_kses_data( __("Select or upload photo of testimonmials author or write URL of photo from other site", 'runcrew') ),
					"class" => "",
					"value" => "",
					"type" => "attach_image"
				),
				runcrew_get_vc_param('id'),
				runcrew_get_vc_param('class'),
				runcrew_get_vc_param('css')
			),
			'js_view' => 'VcTrxColumnItemView'
		) );

		class WPBakeryShortCode_Trx_Testimonials extends RUNCREW_VC_ShortCodeColumns {}
		class WPBakeryShortCode_Trx_Testimonials_Item extends RUNCREW_VC_ShortCodeCollection {}

	}
}


// ---------------------------------- [trx_services] ---------------------------------------
if ( !function_exists( 'runcrew_sc_services' ) ) {
	function runcrew_sc_services($atts, $content=null){
		if (runcrew_in_shortcode_blogger()) return '';
		extract(runcrew_html_decode(shortcode_atts(array(
			// Individual params
			"style" => "services-1",
			"columns" => 4,
			"slider" => "no",
			"slides_space" => 0,
			"controls" => "no",
			"interval" => "",
			"autoheight" => "no",
			"align" => "",
			"custom" => "no",
			"type" => "icons",	// icons | images
			"ids" => "",
			"cat" => "",
			"count" => 4,
			"offset" => "",
			"orderby" => "date",
			"order" => "desc",
			"readmore" => esc_html__('Learn more', 'trx_utils'),
			"title" => "",
			"subtitle" => "",
			"description" => "",
			"link_caption" => esc_html__('Learn more', 'trx_utils'),
			"link" => '',
			"scheme" => '',
			"image" => '',
			"image_align" => '',
			"popup" => "no",
			"link_popup" => "",
			// Common params
			"id" => "",
			"class" => "",
			"animation" => "",
			"css" => "",
			"width" => "",
			"height" => "",
			"top" => "",
			"bottom" => "",
			"left" => "",
			"right" => ""
		), $atts)));

		if (runcrew_param_is_off($slider) && $columns > 1 && $style == 'services-5' && !empty($image)) $columns = 2;
		if (!empty($image)) {
			if ($image > 0) {
				$attach = wp_get_attachment_image_src( $image, 'full' );
				if (isset($attach[0]) && $attach[0]!='')
					$image = $attach[0];
			}
		}

		if (empty($id)) $id = "sc_services_".str_replace('.', '', mt_rand());
		if (empty($width)) $width = "100%";
		if (!empty($height) && runcrew_param_is_on($autoheight)) $autoheight = "no";
		if (empty($interval)) $interval = mt_rand(5000, 10000);

		$class .= ($class ? ' ' : '') . runcrew_get_css_position_as_classes($top, $right, $bottom, $left);

		$ws = runcrew_get_css_dimensions_from_values($width);
		$hs = runcrew_get_css_dimensions_from_values('', $height);
		$css .= ($hs) . ($ws);

		$columns = max(1, min(12, (int) $columns));
		$count = max(1, (int) $count);
		if (runcrew_param_is_off($custom) && $count < $columns) $columns = $count;

		if (runcrew_param_is_on($slider)) runcrew_enqueue_slider('swiper');

		runcrew_storage_set('sc_services_data', array(
				'id' => $id,
				'style' => $style,
				'type' => $type,
				'columns' => $columns,
				'counter' => 0,
				'slider' => $slider,
				'css_wh' => $ws . $hs,
				'readmore' => $readmore
			)
		);

		if (runcrew_param_is_on($popup)) runcrew_enqueue_popup('magnific');

		$output = '<div' . ($id ? ' id="'.esc_attr($id).'_wrap"' : '')
			. ' class="sc_services_wrap'
			. ($scheme && !runcrew_param_is_off($scheme) && !runcrew_param_is_inherit($scheme) ? ' scheme_'.esc_attr($scheme) : '')
			.'">'
			. '<div' . ($id ? ' id="'.esc_attr($id).'"' : '')
			. ' class="sc_services'
			. ' sc_services_style_'.esc_attr($style)
			. ' sc_services_type_'.esc_attr($type)
			. ' ' . esc_attr(runcrew_get_template_property($style, 'container_classes'))
			. (!empty($class) ? ' '.esc_attr($class) : '')
			. ($align!='' && $align!='none' ? ' align'.esc_attr($align) : '')
			. '"'
			. ($css!='' ? ' style="'.esc_attr($css).'"' : '')
			. (!runcrew_param_is_off($animation) ? ' data-animation="'.esc_attr(runcrew_get_animation_classes($animation)).'"' : '')
			. '>'
			. (!empty($subtitle) ? '<h6 class="sc_services_subtitle sc_item_subtitle">' . trim(runcrew_strmacros($subtitle)) . '</h6>' : '')
			. (!empty($title) ? '<h2 class="sc_services_title sc_item_title">' . trim(runcrew_strmacros($title)) . '</h2>' : '')
			. (!empty($description) ? '<div class="sc_services_descr sc_item_descr">' . trim(runcrew_strmacros($description)) . '</div>' : '')
			. (runcrew_param_is_on($slider)
				? ('<div class="sc_slider_swiper swiper-slider-container'
					. ' ' . esc_attr(runcrew_get_slider_controls_classes($controls))
					. (runcrew_param_is_on($autoheight) ? ' sc_slider_height_auto' : '')
					. ($hs ? ' sc_slider_height_fixed' : '')
					. '"'
					. (!empty($width) && runcrew_strpos($width, '%')===false ? ' data-old-width="' . esc_attr($width) . '"' : '')
					. (!empty($height) && runcrew_strpos($height, '%')===false ? ' data-old-height="' . esc_attr($height) . '"' : '')
					. ((int) $interval > 0 ? ' data-interval="'.esc_attr($interval).'"' : '')
					. ($columns > 1 ? ' data-slides-per-view="' . esc_attr($columns) . '"' : '')
					. ($slides_space > 0 ? ' data-slides-space="' . esc_attr($slides_space) . '"' : '')
					. ' data-slides-min-width="250"'
					. '>'
					. '<div class="slides swiper-wrapper">')
				: ($columns > 1
					? ($style == 'services-5' && !empty($image)
						? '<div class="sc_service_container sc_align_'.esc_attr($image_align).'">'
						. '<div class="sc_services_image">'
						. ((runcrew_param_is_on($popup) && !empty($link_popup))
							? '<a href="'.esc_url($link_popup).'" class="sc_popup_link"><img src="'.esc_url($image).'" alt="'.esc_attr__('img', 'trx_utils').'"></a>'
							: '<img src="'.esc_url($image).'" alt="'.esc_attr__('img', 'trx_utils').'">')
						. '</div>'
						: '')
					. '<div class="sc_columns columns_wrap">'
					: '')
			);

		$content = do_shortcode($content);

		if (runcrew_param_is_on($custom) && $content) {
			$output .= $content;
		} else {
			global $post;

			if (!empty($ids)) {
				$posts = explode(',', $ids);
				$count = count($posts);
			}

			$args = array(
				'post_type' => 'services',
				'post_status' => 'publish',
				'posts_per_page' => $count,
				'ignore_sticky_posts' => true,
				'order' => $order=='asc' ? 'asc' : 'desc',
				'readmore' => $readmore
			);

			if ($offset > 0 && empty($ids)) {
				$args['offset'] = $offset;
			}

			$args = runcrew_query_add_sort_order($args, $orderby, $order);
			$args = runcrew_query_add_posts_and_cats($args, $ids, 'services', $cat, 'services_group');

			$query = new WP_Query( $args );

			$post_number = 0;

			while ( $query->have_posts() ) {
				$query->the_post();
				$post_number++;
				$args = array(
					'layout' => $style,
					'show' => false,
					'number' => $post_number,
					'posts_on_page' => ($count > 0 ? $count : $query->found_posts),
					"descr" => runcrew_get_custom_option('post_excerpt_maxlength'.($columns > 1 ? '_masonry' : '')),
					"orderby" => $orderby,
					'content' => false,
					'terms_list' => false,
					'readmore' => $readmore,
					'tag_type' => $type,
					'columns_count' => $columns,
					'slider' => $slider,
					'tag_id' => $id ? $id . '_' . $post_number : '',
					'tag_class' => '',
					'tag_animation' => '',
					'tag_css' => '',
					'tag_css_wh' => $ws . $hs
				);
				$output .= runcrew_show_post_layout($args);
			}
			wp_reset_postdata();
		}

		if (runcrew_param_is_on($slider)) {
			$output .= '</div>'
				. '<div class="sc_slider_controls_wrap"><a class="sc_slider_prev" href="#"></a><a class="sc_slider_next" href="#"></a></div>'
				. '<div class="sc_slider_pagination_wrap"></div>'
				. '</div>';
		} else if ($columns > 1) {
			$output .= '</div>';
			if ($style == 'services-5' && !empty($image))
				$output .= '</div>';
		}

		$output .=  (!empty($link) ? '<div class="sc_services_button sc_item_button">'.runcrew_do_shortcode('[trx_button link="'.esc_url($link).'" size="large"]'.esc_html($link_caption).'[/trx_button]').'</div>' : '')
			. '</div><!-- /.sc_services -->'
			. '</div><!-- /.sc_services_wrap -->';

		// Add template specific scripts and styles
		do_action('runcrew_action_blog_scripts', $style);

		return apply_filters('runcrew_shortcode_output', $output, 'trx_services', $atts, $content);
	}
	add_shortcode('trx_services', 'runcrew_sc_services');
}


if ( !function_exists( 'runcrew_sc_services_item' ) ) {
	function runcrew_sc_services_item($atts, $content=null) {
		if (runcrew_in_shortcode_blogger()) return '';
		extract(runcrew_html_decode(shortcode_atts( array(
			// Individual params
			"icon" => "",
			"image" => "",
			"title" => "",
			"link" => "",
			"readmore" => "(none)",
			// Common params
			"id" => "",
			"class" => "",
			"animation" => "",
			"css" => ""
		), $atts)));

		runcrew_storage_inc_array('sc_services_data', 'counter');

		$id = $id ? $id : (runcrew_storage_get_array('sc_services_data', 'id') ? runcrew_storage_get_array('sc_services_data', 'id') . '_' . runcrew_storage_get_array('sc_services_data', 'counter') : '');

		$descr = trim(chop(do_shortcode($content)));
		$readmore = $readmore=='(none)' ? runcrew_storage_get_array('sc_services_data', 'readmore') : $readmore;

		$type = runcrew_storage_get_array('sc_services_data', 'type');
		if (!empty($icon)) {
			$type = 'icons';
		} else if (!empty($image)) {
			$type = 'images';
			if ($image > 0) {
				$attach = wp_get_attachment_image_src( $image, 'full' );
				if (isset($attach[0]) && $attach[0]!='')
					$image = $attach[0];
			}
			$thumb_sizes = runcrew_get_thumb_sizes(array('layout' => runcrew_storage_get_array('sc_services_data', 'style')));
			$image = runcrew_get_resized_image_tag($image, $thumb_sizes['w'], $thumb_sizes['h']);
		}

		$post_data = array(
			'post_title' => $title,
			'post_excerpt' => $descr,
			'post_thumb' => $image,
			'post_icon' => $icon,
			'post_link' => $link,
			'post_protected' => false,
			'post_format' => 'standard'
		);
		$args = array(
			'layout' => runcrew_storage_get_array('sc_services_data', 'style'),
			'number' => runcrew_storage_get_array('sc_services_data', 'counter'),
			'columns_count' => runcrew_storage_get_array('sc_services_data', 'columns'),
			'slider' => runcrew_storage_get_array('sc_services_data', 'slider'),
			'show' => false,
			'descr'  => -1,		// -1 - don't strip tags, 0 - strip_tags, >0 - strip_tags and truncate string
			'readmore' => $readmore,
			'tag_type' => $type,
			'tag_id' => $id,
			'tag_class' => $class,
			'tag_animation' => $animation,
			'tag_css' => $css,
			'tag_css_wh' => runcrew_storage_get_array('sc_services_data', 'css_wh')
		);
		$output = runcrew_show_post_layout($args, $post_data);
		return apply_filters('runcrew_shortcode_output', $output, 'trx_services_item', $atts, $content);
	}
	add_shortcode('trx_services_item', 'runcrew_sc_services_item');
}
// ---------------------------------- [/trx_services] ---------------------------------------



// Add [trx_services] and [trx_services_item] in the shortcodes list
if (!function_exists('runcrew_services_reg_shortcodes')) {
	function runcrew_services_reg_shortcodes() {
		if (runcrew_storage_isset('shortcodes')) {

			$services_groups = runcrew_get_list_terms(false, 'services_group');
			$services_styles = runcrew_get_list_templates('services');
			$controls 		 = runcrew_get_list_slider_controls();

			runcrew_sc_map_after('trx_section', array(

				// Services
				"trx_services" => array(
					"title" => esc_html__("Services", 'trx_utils'),
					"desc" => wp_kses_data( __("Insert services list in your page (post)", 'trx_utils') ),
					"decorate" => true,
					"container" => false,
					"params" => array(
						"title" => array(
							"title" => esc_html__("Title", 'trx_utils'),
							"desc" => wp_kses_data( __("Title for the block", 'trx_utils') ),
							"value" => "",
							"type" => "text"
						),
						"subtitle" => array(
							"title" => esc_html__("Subtitle", 'trx_utils'),
							"desc" => wp_kses_data( __("Subtitle for the block", 'trx_utils') ),
							"value" => "",
							"type" => "text"
						),
						"description" => array(
							"title" => esc_html__("Description", 'trx_utils'),
							"desc" => wp_kses_data( __("Short description for the block", 'trx_utils') ),
							"value" => "",
							"type" => "textarea"
						),
						"style" => array(
							"title" => esc_html__("Services style", 'trx_utils'),
							"desc" => wp_kses_data( __("Select style to display services list", 'trx_utils') ),
							"value" => "services-1",
							"type" => "select",
							"options" => $services_styles
						),
						"image" => array(
							"title" => esc_html__("Item's image", 'trx_utils'),
							"desc" => wp_kses_data( __("Item's image", 'trx_utils') ),
							"dependency" => array(
								'style' => 'services-5'
							),
							"value" => "",
							"readonly" => false,
							"type" => "media"
						),
						"image_align" => array(
							"title" => esc_html__("Image alignment", 'trx_utils'),
							"desc" => wp_kses_data( __("Alignment of the image", 'trx_utils') ),
							"divider" => true,
							"value" => "",
							"type" => "checklist",
							"dir" => "horizontal",
							"options" => runcrew_get_sc_param('align')
						),
						"popup" => array(
							"title" => esc_html__("Open link in popup", 'trx_utils'),
							"desc" => wp_kses_data( __("Open link target in popup window", 'trx_utils') ),
							"dependency" => array(
								'style' => array('services-5')
							),
							"value" => "no",
							"type" => "switch",
							"options" => runcrew_get_sc_param('yes_no')
						),
						"link_popup" => array(
							"title" => esc_html__("Link URL for Popup", 'trx_utils'),
							"desc" => wp_kses_data( __("URL for link on image click", 'trx_utils') ),
							"divider" => true,
							"dependency" => array(
								'style' => array('services-5')
							),
							"value" => "",
							"type" => "text"
						),
						"type" => array(
							"title" => esc_html__("Icon's type", 'trx_utils'),
							"desc" => wp_kses_data( __("Select type of icons: font icon or image", 'trx_utils') ),
							"value" => "icons",
							"type" => "checklist",
							"dir" => "horizontal",
							"options" => array(
								'icons'  => esc_html__('Icons', 'trx_utils'),
								'images' => esc_html__('Images', 'trx_utils')
							)
						),
						"columns" => array(
							"title" => esc_html__("Columns", 'trx_utils'),
							"desc" => wp_kses_data( __("How many columns use to show services list", 'trx_utils') ),
							"value" => 4,
							"min" => 2,
							"max" => 6,
							"step" => 1,
							"type" => "spinner"
						),
						"scheme" => array(
							"title" => esc_html__("Color scheme", 'trx_utils'),
							"desc" => wp_kses_data( __("Select color scheme for this block", 'trx_utils') ),
							"value" => "",
							"type" => "checklist",
							"options" => runcrew_get_sc_param('schemes')
						),
						"slider" => array(
							"title" => esc_html__("Slider", 'trx_utils'),
							"desc" => wp_kses_data( __("Use slider to show services", 'trx_utils') ),
							"value" => "no",
							"type" => "switch",
							"options" => runcrew_get_sc_param('yes_no')
						),
						"controls" => array(
							"title" => esc_html__("Controls", 'trx_utils'),
							"desc" => wp_kses_data( __("Slider controls style and position", 'trx_utils') ),
							"dependency" => array(
								'slider' => array('yes')
							),
							"divider" => true,
							"value" => "",
							"type" => "checklist",
							"dir" => "horizontal",
							"options" => $controls
						),
						"slides_space" => array(
							"title" => esc_html__("Space between slides", 'trx_utils'),
							"desc" => wp_kses_data( __("Size of space (in px) between slides", 'trx_utils') ),
							"dependency" => array(
								'slider' => array('yes')
							),
							"value" => 0,
							"min" => 0,
							"max" => 100,
							"step" => 10,
							"type" => "spinner"
						),
						"interval" => array(
							"title" => esc_html__("Slides change interval", 'trx_utils'),
							"desc" => wp_kses_data( __("Slides change interval (in milliseconds: 1000ms = 1s)", 'trx_utils') ),
							"dependency" => array(
								'slider' => array('yes')
							),
							"value" => 7000,
							"step" => 500,
							"min" => 0,
							"type" => "spinner"
						),
						"autoheight" => array(
							"title" => esc_html__("Autoheight", 'trx_utils'),
							"desc" => wp_kses_data( __("Change whole slider's height (make it equal current slide's height)", 'trx_utils') ),
							"dependency" => array(
								'slider' => array('yes')
							),
							"value" => "yes",
							"type" => "switch",
							"options" => runcrew_get_sc_param('yes_no')
						),
						"align" => array(
							"title" => esc_html__("Alignment", 'trx_utils'),
							"desc" => wp_kses_data( __("Alignment of the services block", 'trx_utils') ),
							"divider" => true,
							"value" => "",
							"type" => "checklist",
							"dir" => "horizontal",
							"options" => runcrew_get_sc_param('align')
						),
						"custom" => array(
							"title" => esc_html__("Custom", 'trx_utils'),
							"desc" => wp_kses_data( __("Allow get services items from inner shortcodes (custom) or get it from specified group (cat)", 'trx_utils') ),
							"divider" => true,
							"value" => "no",
							"type" => "switch",
							"options" => runcrew_get_sc_param('yes_no')
						),
						"cat" => array(
							"title" => esc_html__("Categories", 'trx_utils'),
							"desc" => wp_kses_data( __("Select categories (groups) to show services list. If empty - select services from any category (group) or from IDs list", 'trx_utils') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"divider" => true,
							"value" => "",
							"type" => "select",
							"style" => "list",
							"multiple" => true,
							"options" => runcrew_array_merge(array(0 => esc_html__('- Select category -', 'trx_utils')), $services_groups)
						),
						"count" => array(
							"title" => esc_html__("Number of posts", 'trx_utils'),
							"desc" => wp_kses_data( __("How many posts will be displayed? If used IDs - this parameter ignored.", 'trx_utils') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => 4,
							"min" => 1,
							"max" => 100,
							"type" => "spinner"
						),
						"offset" => array(
							"title" => esc_html__("Offset before select posts", 'trx_utils'),
							"desc" => wp_kses_data( __("Skip posts before select next part.", 'trx_utils') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => 0,
							"min" => 0,
							"type" => "spinner"
						),
						"orderby" => array(
							"title" => esc_html__("Post order by", 'trx_utils'),
							"desc" => wp_kses_data( __("Select desired posts sorting method", 'trx_utils') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => "date",
							"type" => "select",
							"options" => runcrew_get_sc_param('sorting')
						),
						"order" => array(
							"title" => esc_html__("Post order", 'trx_utils'),
							"desc" => wp_kses_data( __("Select desired posts order", 'trx_utils') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => "desc",
							"type" => "switch",
							"size" => "big",
							"options" => runcrew_get_sc_param('ordering')
						),
						"ids" => array(
							"title" => esc_html__("Post IDs list", 'trx_utils'),
							"desc" => wp_kses_data( __("Comma separated list of posts ID. If set - parameters above are ignored!", 'trx_utils') ),
							"dependency" => array(
								'custom' => array('no')
							),
							"value" => "",
							"type" => "text"
						),
						"readmore" => array(
							"title" => esc_html__("Read more", 'trx_utils'),
							"desc" => wp_kses_data( __("Caption for the Read more link (if empty - link not showed)", 'trx_utils') ),
							"value" => "",
							"type" => "text"
						),
						"link" => array(
							"title" => esc_html__("Button URL", 'trx_utils'),
							"desc" => wp_kses_data( __("Link URL for the button at the bottom of the block", 'trx_utils') ),
							"value" => "",
							"type" => "text"
						),
						"link_caption" => array(
							"title" => esc_html__("Button caption", 'trx_utils'),
							"desc" => wp_kses_data( __("Caption for the button at the bottom of the block", 'trx_utils') ),
							"value" => "",
							"type" => "text"
						),
						"width" => runcrew_shortcodes_width(),
						"height" => runcrew_shortcodes_height(),
						"top" => runcrew_get_sc_param('top'),
						"bottom" => runcrew_get_sc_param('bottom'),
						"left" => runcrew_get_sc_param('left'),
						"right" => runcrew_get_sc_param('right'),
						"id" => runcrew_get_sc_param('id'),
						"class" => runcrew_get_sc_param('class'),
						"animation" => runcrew_get_sc_param('animation'),
						"css" => runcrew_get_sc_param('css')
					),
					"children" => array(
						"name" => "trx_services_item",
						"title" => esc_html__("Service item", 'trx_utils'),
						"desc" => wp_kses_data( __("Service item", 'trx_utils') ),
						"container" => true,
						"params" => array(
							"title" => array(
								"title" => esc_html__("Title", 'trx_utils'),
								"desc" => wp_kses_data( __("Item's title", 'trx_utils') ),
								"divider" => true,
								"value" => "",
								"type" => "text"
							),
							"icon" => array(
								"title" => esc_html__("Item's icon",  'trx_utils'),
								"desc" => wp_kses_data( __('Select icon for the item from Fontello icons set',  'trx_utils') ),
								"value" => "",
								"type" => "icons",
								"options" => runcrew_get_sc_param('icons')
							),
							"image" => array(
								"title" => esc_html__("Item's image", 'trx_utils'),
								"desc" => wp_kses_data( __("Item's image (if icon not selected)", 'trx_utils') ),
								"dependency" => array(
									'icon' => array('is_empty', 'none')
								),
								"value" => "",
								"readonly" => false,
								"type" => "media"
							),
							"link" => array(
								"title" => esc_html__("Link", 'trx_utils'),
								"desc" => wp_kses_data( __("Link on service's item page", 'trx_utils') ),
								"divider" => true,
								"value" => "",
								"type" => "text"
							),
							"readmore" => array(
								"title" => esc_html__("Read more", 'trx_utils'),
								"desc" => wp_kses_data( __("Caption for the Read more link (if empty - link not showed)", 'trx_utils') ),
								"value" => "",
								"type" => "text"
							),
							"_content_" => array(
								"title" => esc_html__("Description", 'trx_utils'),
								"desc" => wp_kses_data( __("Item's short description", 'trx_utils') ),
								"divider" => true,
								"rows" => 4,
								"value" => "",
								"type" => "textarea"
							),
							"id" => runcrew_get_sc_param('id'),
							"class" => runcrew_get_sc_param('class'),
							"animation" => runcrew_get_sc_param('animation'),
							"css" => runcrew_get_sc_param('css')
						)
					)
				)

			));
		}
	}
}


// Add [trx_services] and [trx_services_item] in the VC shortcodes list
if (!function_exists('runcrew_services_reg_shortcodes_vc')) {
	function runcrew_services_reg_shortcodes_vc() {

		$services_groups = runcrew_get_list_terms(false, 'services_group');
		$services_styles = runcrew_get_list_templates('services');
		$controls		 = runcrew_get_list_slider_controls();

		// Services
		vc_map( array(
			"base" => "trx_services",
			"name" => esc_html__("Services", 'trx_utils'),
			"description" => wp_kses_data( __("Insert services list", 'trx_utils') ),
			"category" => esc_html__('Content', 'trx_utils'),
			"icon" => 'icon_trx_services',
			"class" => "trx_sc_columns trx_sc_services",
			"content_element" => true,
			"is_container" => true,
			"show_settings_on_create" => true,
			"as_parent" => array('only' => 'trx_services_item'),
			"params" => array(
				array(
					"param_name" => "style",
					"heading" => esc_html__("Services style", 'trx_utils'),
					"description" => wp_kses_data( __("Select style to display services list", 'trx_utils') ),
					"class" => "",
					"admin_label" => true,
					"value" => array_flip($services_styles),
					"type" => "dropdown"
				),
				array(
					"param_name" => "type",
					"heading" => esc_html__("Icon's type", 'trx_utils'),
					"description" => wp_kses_data( __("Select type of icons: font icon or image", 'trx_utils') ),
					"class" => "",
					"admin_label" => true,
					"value" => array(
						esc_html__('Icons', 'trx_utils') => 'icons',
						esc_html__('Images', 'trx_utils') => 'images'
					),
					"type" => "dropdown"
				),
				array(
					"param_name" => "scheme",
					"heading" => esc_html__("Color scheme", 'trx_utils'),
					"description" => wp_kses_data( __("Select color scheme for this block", 'trx_utils') ),
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('schemes')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "image",
					"heading" => esc_html__("Image", 'trx_utils'),
					"description" => wp_kses_data( __("Item's image", 'trx_utils') ),
					'dependency' => array(
						'element' => 'style',
						'value' => 'services-5'
					),
					"class" => "",
					"value" => "",
					"type" => "attach_image"
				),
				array(
					"param_name" => "image_align",
					"heading" => esc_html__("Image alignment", 'trx_utils'),
					"description" => wp_kses_data( __("Alignment of the image", 'trx_utils') ),
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('align')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "popup",
					"heading" => esc_html__("Open link in popup", 'trx_utils'),
					"description" => wp_kses_data( __("Open link target in popup window", 'trx_utils') ),
					'dependency' => array(
						'element' => 'style',
						'value' => array('services-5')
					),
					"class" => "",
					"group" => esc_html__('Popup', 'trx_utils'),
					"value" => array(esc_html__('Open in popup', 'trx_utils') => 'yes'),
					"type" => "checkbox"
				),
				array(
					"param_name" => "link_popup",
					"heading" => esc_html__("Link URL for Popup", 'trx_utils'),
					"description" => wp_kses_data( __("URL for the link on image click", 'trx_utils') ),
					'dependency' => array(
						'element' => 'style',
						'value' => array('services-5')
					),
					"class" => "",
					"group" => esc_html__('Popup', 'trx_utils'),
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "slider",
					"heading" => esc_html__("Slider", 'trx_utils'),
					"description" => wp_kses_data( __("Use slider to show services", 'trx_utils') ),
					"admin_label" => true,
					"group" => esc_html__('Slider', 'trx_utils'),
					"class" => "",
					"std" => "no",
					"value" => array_flip(runcrew_get_sc_param('yes_no')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "controls",
					"heading" => esc_html__("Controls", 'trx_utils'),
					"description" => wp_kses_data( __("Slider controls style and position", 'trx_utils') ),
					"admin_label" => true,
					"group" => esc_html__('Slider', 'trx_utils'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"std" => "no",
					"value" => array_flip($controls),
					"type" => "dropdown"
				),
				array(
					"param_name" => "slides_space",
					"heading" => esc_html__("Space between slides", 'trx_utils'),
					"description" => wp_kses_data( __("Size of space (in px) between slides", 'trx_utils') ),
					"admin_label" => true,
					"group" => esc_html__('Slider', 'trx_utils'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"value" => "0",
					"type" => "textfield"
				),
				array(
					"param_name" => "interval",
					"heading" => esc_html__("Slides change interval", 'trx_utils'),
					"description" => wp_kses_data( __("Slides change interval (in milliseconds: 1000ms = 1s)", 'trx_utils') ),
					"group" => esc_html__('Slider', 'trx_utils'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"value" => "7000",
					"type" => "textfield"
				),
				array(
					"param_name" => "autoheight",
					"heading" => esc_html__("Autoheight", 'trx_utils'),
					"description" => wp_kses_data( __("Change whole slider's height (make it equal current slide's height)", 'trx_utils') ),
					"group" => esc_html__('Slider', 'trx_utils'),
					'dependency' => array(
						'element' => 'slider',
						'value' => 'yes'
					),
					"class" => "",
					"value" => array("Autoheight" => "yes" ),
					"type" => "checkbox"
				),
				array(
					"param_name" => "align",
					"heading" => esc_html__("Alignment", 'trx_utils'),
					"description" => wp_kses_data( __("Alignment of the services block", 'trx_utils') ),
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('align')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "custom",
					"heading" => esc_html__("Custom", 'trx_utils'),
					"description" => wp_kses_data( __("Allow get services from inner shortcodes (custom) or get it from specified group (cat)", 'trx_utils') ),
					"class" => "",
					"value" => array("Custom services" => "yes" ),
					"type" => "checkbox"
				),
				array(
					"param_name" => "title",
					"heading" => esc_html__("Title", 'trx_utils'),
					"description" => wp_kses_data( __("Title for the block", 'trx_utils') ),
					"admin_label" => true,
					"group" => esc_html__('Captions', 'trx_utils'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "subtitle",
					"heading" => esc_html__("Subtitle", 'trx_utils'),
					"description" => wp_kses_data( __("Subtitle for the block", 'trx_utils') ),
					"group" => esc_html__('Captions', 'trx_utils'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "description",
					"heading" => esc_html__("Description", 'trx_utils'),
					"description" => wp_kses_data( __("Description for the block", 'trx_utils') ),
					"group" => esc_html__('Captions', 'trx_utils'),
					"class" => "",
					"value" => "",
					"type" => "textarea"
				),
				array(
					"param_name" => "cat",
					"heading" => esc_html__("Categories", 'trx_utils'),
					"description" => wp_kses_data( __("Select category to show services. If empty - select services from any category (group) or from IDs list", 'trx_utils') ),
					"group" => esc_html__('Query', 'trx_utils'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"class" => "",
					"value" => array_flip(runcrew_array_merge(array(0 => esc_html__('- Select category -', 'trx_utils')), $services_groups)),
					"type" => "dropdown"
				),
				array(
					"param_name" => "columns",
					"heading" => esc_html__("Columns", 'trx_utils'),
					"description" => wp_kses_data( __("How many columns use to show services list", 'trx_utils') ),
					"group" => esc_html__('Query', 'trx_utils'),
					"admin_label" => true,
					"class" => "",
					"value" => "4",
					"type" => "textfield"
				),
				array(
					"param_name" => "count",
					"heading" => esc_html__("Number of posts", 'trx_utils'),
					"description" => wp_kses_data( __("How many posts will be displayed? If used IDs - this parameter ignored.", 'trx_utils') ),
					"admin_label" => true,
					"group" => esc_html__('Query', 'trx_utils'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"class" => "",
					"value" => "4",
					"type" => "textfield"
				),
				array(
					"param_name" => "offset",
					"heading" => esc_html__("Offset before select posts", 'trx_utils'),
					"description" => wp_kses_data( __("Skip posts before select next part.", 'trx_utils') ),
					"group" => esc_html__('Query', 'trx_utils'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"class" => "",
					"value" => "0",
					"type" => "textfield"
				),
				array(
					"param_name" => "orderby",
					"heading" => esc_html__("Post sorting", 'trx_utils'),
					"description" => wp_kses_data( __("Select desired posts sorting method", 'trx_utils') ),
					"group" => esc_html__('Query', 'trx_utils'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"std" => "date",
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('sorting')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "order",
					"heading" => esc_html__("Post order", 'trx_utils'),
					"description" => wp_kses_data( __("Select desired posts order", 'trx_utils') ),
					"group" => esc_html__('Query', 'trx_utils'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"std" => "desc",
					"class" => "",
					"value" => array_flip(runcrew_get_sc_param('ordering')),
					"type" => "dropdown"
				),
				array(
					"param_name" => "ids",
					"heading" => esc_html__("Service's IDs list", 'trx_utils'),
					"description" => wp_kses_data( __("Comma separated list of service's ID. If set - parameters above (category, count, order, etc.)  are ignored!", 'trx_utils') ),
					"group" => esc_html__('Query', 'trx_utils'),
					'dependency' => array(
						'element' => 'custom',
						'is_empty' => true
					),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "readmore",
					"heading" => esc_html__("Read more", 'trx_utils'),
					"description" => wp_kses_data( __("Caption for the Read more link (if empty - link not showed)", 'trx_utils') ),
					"admin_label" => true,
					"group" => esc_html__('Captions', 'trx_utils'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "link",
					"heading" => esc_html__("Button URL", 'trx_utils'),
					"description" => wp_kses_data( __("Link URL for the button at the bottom of the block", 'trx_utils') ),
					"group" => esc_html__('Captions', 'trx_utils'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "link_caption",
					"heading" => esc_html__("Button caption", 'trx_utils'),
					"description" => wp_kses_data( __("Caption for the button at the bottom of the block", 'trx_utils') ),
					"group" => esc_html__('Captions', 'trx_utils'),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				runcrew_vc_width(),
				runcrew_vc_height(),
				runcrew_get_vc_param('margin_top'),
				runcrew_get_vc_param('margin_bottom'),
				runcrew_get_vc_param('margin_left'),
				runcrew_get_vc_param('margin_right'),
				runcrew_get_vc_param('id'),
				runcrew_get_vc_param('class'),
				runcrew_get_vc_param('animation'),
				runcrew_get_vc_param('css')
			),
			'default_content' => '
					[trx_services_item title="' . esc_html__( 'Service item 1', 'trx_utils' ) . '"][/trx_services_item]
					[trx_services_item title="' . esc_html__( 'Service item 2', 'trx_utils' ) . '"][/trx_services_item]
					[trx_services_item title="' . esc_html__( 'Service item 3', 'trx_utils' ) . '"][/trx_services_item]
					[trx_services_item title="' . esc_html__( 'Service item 4', 'trx_utils' ) . '"][/trx_services_item]
				',
			'js_view' => 'VcTrxColumnsView'
		) );


		vc_map( array(
			"base" => "trx_services_item",
			"name" => esc_html__("Services item", 'trx_utils'),
			"description" => wp_kses_data( __("Custom services item - all data pull out from shortcode parameters", 'trx_utils') ),
			"show_settings_on_create" => true,
			"class" => "trx_sc_collection trx_sc_column_item trx_sc_services_item",
			"content_element" => true,
			"is_container" => true,
			'icon' => 'icon_trx_services_item',
			"as_child" => array('only' => 'trx_services'),
			"as_parent" => array('except' => 'trx_services'),
			"params" => array(
				array(
					"param_name" => "title",
					"heading" => esc_html__("Title", 'trx_utils'),
					"description" => wp_kses_data( __("Item's title", 'trx_utils') ),
					"admin_label" => true,
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "icon",
					"heading" => esc_html__("Icon", 'trx_utils'),
					"description" => wp_kses_data( __("Select icon for the item from Fontello icons set", 'trx_utils') ),
					"admin_label" => true,
					"class" => "",
					"value" => runcrew_get_sc_param('icons'),
					"type" => "dropdown"
				),
				array(
					"param_name" => "image",
					"heading" => esc_html__("Image", 'trx_utils'),
					"description" => wp_kses_data( __("Item's image (if icon is empty)", 'trx_utils') ),
					"class" => "",
					"value" => "",
					"type" => "attach_image"
				),
				array(
					"param_name" => "link",
					"heading" => esc_html__("Link", 'trx_utils'),
					"description" => wp_kses_data( __("Link on item's page", 'trx_utils') ),
					"admin_label" => true,
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				array(
					"param_name" => "readmore",
					"heading" => esc_html__("Read more", 'trx_utils'),
					"description" => wp_kses_data( __("Caption for the Read more link (if empty - link not showed)", 'trx_utils') ),
					"class" => "",
					"value" => "",
					"type" => "textfield"
				),
				runcrew_get_vc_param('id'),
				runcrew_get_vc_param('class'),
				runcrew_get_vc_param('animation'),
				runcrew_get_vc_param('css')
			),
			'js_view' => 'VcTrxColumnItemView'
		) );

		class WPBakeryShortCode_Trx_Services extends RUNCREW_VC_ShortCodeColumns {}
		class WPBakeryShortCode_Trx_Services_Item extends RUNCREW_VC_ShortCodeCollection {}

	}
}

// Shortcodes
//------------------------------------------------------------------------

if ( !function_exists( 'runcrew_sc_events' ) ) {
    function runcrew_sc_events($atts, $content=null){
        if ( runcrew_in_shortcode_blogger() || !runcrew_exists_tribe_events() ) return '';
        extract(runcrew_html_decode(shortcode_atts(array(
            // Individual params
            "style" => "events-1",
            "columns" => 4,
            "slider" => "no",
            "slides_space" => 0,
            "controls" => "no",
            "interval" => "",
            "autoheight" => "no",
            "align" => "",
            "ids" => "",
            "cat" => "",
            "count" => 4,
            "offset" => "",
            "orderby" => "event_date",
            "order" => "asc",
            "readmore" => esc_html__('Read more', 'runcrew'),
            "title" => "",
            "subtitle" => "",
            "description" => "",
            "link_caption" => esc_html__('Learn more', 'runcrew'),
            "link" => '',
            "scheme" => '',
            // Common params
            "id" => "",
            "class" => "",
            "animation" => "",
            "css" => "",
            "width" => "",
            "height" => "",
            "top" => "",
            "bottom" => "",
            "left" => "",
            "right" => ""
        ), $atts)));

        if (empty($id)) $id = "sc_events_".str_replace('.', '', mt_rand());
        if (empty($width)) $width = "100%";
        if (!empty($height) && runcrew_param_is_on($autoheight)) $autoheight = "no";
        if (empty($interval)) $interval = mt_rand(5000, 10000);

        $class .= ($class ? ' ' : '') . runcrew_get_css_position_as_classes($top, $right, $bottom, $left);

        $ws = runcrew_get_css_dimensions_from_values($width);
        $hs = runcrew_get_css_dimensions_from_values('', $height);
        $css .= ($hs) . ($ws);

        $count = max(1, (int) $count);
        $columns = max(1, min(12, (int) $columns));
        if ($count < $columns) $columns = $count;

        if (runcrew_param_is_on($slider)) runcrew_enqueue_slider('swiper');

        $output = '<div' . ($id ? ' id="'.esc_attr($id).'_wrap"' : '')
            . ' class="sc_events_wrap'
            . ($scheme && !runcrew_param_is_off($scheme) && !runcrew_param_is_inherit($scheme) ? ' scheme_'.esc_attr($scheme) : '')
            .'">'
            . '<div' . ($id ? ' id="'.esc_attr($id).'"' : '')
            . ' class="sc_events'
            . ' sc_events_style_'.esc_attr($style)
            . ' ' . esc_attr(runcrew_get_template_property($style, 'container_classes'))
            . (!empty($class) ? ' '.esc_attr($class) : '')
            . ($align!='' && $align!='none' ? ' align'.esc_attr($align) : '')
            . '"'
            . ($css!='' ? ' style="'.esc_attr($css).'"' : '')
            . (!runcrew_param_is_off($animation) ? ' data-animation="'.esc_attr(runcrew_get_animation_classes($animation)).'"' : '')
            . '>'
            . (!empty($subtitle) ? '<h6 class="sc_events_subtitle sc_item_subtitle">' . trim(runcrew_strmacros($subtitle)) . '</h6>' : '')
            . (!empty($title) ? '<h2 class="sc_events_title sc_item_title' . (empty($description) ? ' sc_item_title_without_descr' : ' sc_item_title_with_descr') . '">' . trim(runcrew_strmacros($title)) . '</h2>' : '')
            . (!empty($description) ? '<div class="sc_events_descr sc_item_descr">' . trim(runcrew_strmacros($description)) . '</div>' : '')
            . (runcrew_param_is_on($slider)
                ? ('<div class="sc_slider_swiper swiper-slider-container'
                    . ' ' . esc_attr(runcrew_get_slider_controls_classes($controls))
                    . (runcrew_param_is_on($autoheight) ? ' sc_slider_height_auto' : '')
                    . ($hs ? ' sc_slider_height_fixed' : '')
                    . '"'
                    . (!empty($width) && runcrew_strpos($width, '%')===false ? ' data-old-width="' . esc_attr($width) . '"' : '')
                    . (!empty($height) && runcrew_strpos($height, '%')===false ? ' data-old-height="' . esc_attr($height) . '"' : '')
                    . ((int) $interval > 0 ? ' data-interval="'.esc_attr($interval).'"' : '')
                    . ($columns > 1 ? ' data-slides-per-view="' . esc_attr($columns) . '"' : '')
                    . ($slides_space > 0 ? ' data-slides-space="' . esc_attr($slides_space) . '"' : '')
                    . '>'
                    . '<div class="slides swiper-wrapper">')
                : ($columns > 1
                    ? '<div class="sc_columns columns_wrap">'
                    : '')
            );

        $content = do_shortcode($content);

        global $post;

        if (!empty($ids)) {
            $posts = explode(',', $ids);
            $count = count($posts);
        }

        $args = array(
            'post_type' => Tribe__Events__Main::POSTTYPE,
            'post_status' => 'publish',
            'posts_per_page' => $count,
            'ignore_sticky_posts' => true,
            'order' => $order=='asc' ? 'asc' : 'desc',
            'tribe_suppress_query_filters' => true,
            'readmore' => $readmore
        );

        if ($offset > 0 && empty($ids)) {
            $args['offset'] = $offset;
        }

	    if (empty($ids)) {
		    $args['meta_query'] = array(
			    array(
				    'key' => '_EventStartDate',
				    'value' => date('Y-m-d'),
				    'compare' => '>='
			    )
		    );
	    }

	    $args = runcrew_query_add_sort_order($args, $orderby, $order);
        $args = runcrew_query_add_posts_and_cats($args, $ids, Tribe__Events__Main::POSTTYPE, $cat, Tribe__Events__Main::TAXONOMY);
        $query = new WP_Query( $args );

        $post_number = 0;

        while ( $query->have_posts() ) {
            $query->the_post();
            $post_number++;
            $args = array(
                'layout' => $style,
                'show' => false,
                'number' => $post_number,
                'posts_on_page' => ($count > 0 ? $count : $query->found_posts),
                "descr" => runcrew_get_custom_option('post_excerpt_maxlength'.($columns > 1 ? '_masonry' : '')),
                "orderby" => $orderby,
                'content' => false,
                'terms_list' => false,
                'readmore' => $readmore,
                'columns_count' => $columns,
                'slider' => $slider,
                'tag_id' => $id ? $id . '_' . $post_number : '',
                'tag_class' => '',
                'tag_animation' => '',
                'tag_css' => '',
                'tag_css_wh' => $ws . $hs
            );
            $output .= runcrew_show_post_layout($args);
        }
        wp_reset_postdata();

        if (runcrew_param_is_on($slider)) {
            $output .= '</div>'
                . '<div class="sc_slider_controls_wrap"><a class="sc_slider_prev" href="#"></a><a class="sc_slider_next" href="#"></a></div>'
                . '<div class="sc_slider_pagination_wrap"></div>'
                . '</div>';
        } else if ($columns > 1) {
            $output .= '</div>';
        }

        $output .=  (!empty($link) ? '<div class="sc_events_button sc_item_button">'.runcrew_do_shortcode('[trx_button link="'.esc_url($link).'" icon="icon-right"]'.esc_html($link_caption).'[/trx_button]').'</div>' : '')
            . '</div><!-- /.sc_events -->'
            . '</div><!-- /.sc_envents_wrap -->';

        // Add template specific scripts and styles
        do_action('runcrew_action_blog_scripts', $style);

        return apply_filters('runcrew_shortcode_output', $output, 'trx_events', $atts, $content);
    }
    //runcrew_require_shortcode('trx_events', 'runcrew_sc_events');
    if (function_exists('runcrew_require_shortcode')) runcrew_require_shortcode('trx_events', 'runcrew_sc_events');
}
// ---------------------------------- [/trx_events] ---------------------------------------



// Add [trx_events] in the shortcodes list
if (!function_exists('runcrew_tribe_events_reg_shortcodes')) {
    //Handler of add_filter('runcrew_action_shortcodes_list',	'runcrew_tribe_events_reg_shortcodes');
    function runcrew_tribe_events_reg_shortcodes() {
        if (runcrew_storage_isset('shortcodes')) {

            $groups		= runcrew_get_list_terms(false, Tribe__Events__Main::TAXONOMY);
            $styles		= runcrew_get_list_templates('events');
            $sorting	= array(
                "event_date"=> esc_html__("Start Date", 'runcrew'),
                "title" 	=> esc_html__("Alphabetically", 'runcrew'),
                "random"	=> esc_html__("Random", 'runcrew')
            );
            $controls	= runcrew_get_list_slider_controls();

            runcrew_sc_map_before('trx_form', "trx_events", array(
                    "title" => esc_html__("Events", "runcrew"),
                    "desc" => esc_html__("Insert events list in your page (post)", "runcrew"),
                    "decorate" => true,
                    "container" => false,
                    "params" => array(
                        "title" => array(
                            "title" => esc_html__("Title", "runcrew"),
                            "desc" => esc_html__("Title for the block", "runcrew"),
                            "value" => "",
                            "type" => "text"
                        ),
                        "subtitle" => array(
                            "title" => esc_html__("Subtitle", "runcrew"),
                            "desc" => esc_html__("Subtitle for the block", "runcrew"),
                            "value" => "",
                            "type" => "text"
                        ),
                        "description" => array(
                            "title" => esc_html__("Description", "runcrew"),
                            "desc" => esc_html__("Short description for the block", "runcrew"),
                            "value" => "",
                            "type" => "textarea"
                        ),
                        "style" => array(
                            "title" => esc_html__("Style", "runcrew"),
                            "desc" => esc_html__("Select style to display events list", "runcrew"),
                            "value" => "events-1",
                            "type" => "select",
                            "options" => $styles
                        ),
                        "columns" => array(
                            "title" => esc_html__("Columns", "runcrew"),
                            "desc" => esc_html__("How many columns use to show events list", "runcrew"),
                            "value" => 4,
                            "min" => 2,
                            "max" => 6,
                            "step" => 1,
                            "type" => "spinner"
                        ),
                        "scheme" => array(
                            "title" => esc_html__("Color scheme", "runcrew"),
                            "desc" => esc_html__("Select color scheme for this block", "runcrew"),
                            "value" => "",
                            "type" => "checklist",
                            "options" => runcrew_get_sc_param('schemes')
                        ),
                        "slider" => array(
                            "title" => esc_html__("Slider", "runcrew"),
                            "desc" => esc_html__("Use slider to show events", "runcrew"),
                            "dependency" => array(
                                'style' => array('events-1')
                            ),
                            "value" => "no",
                            "type" => "switch",
                            "options" => runcrew_get_sc_param('yes_no')
                        ),
                        "controls" => array(
                            "title" => esc_html__("Controls", "runcrew"),
                            "desc" => esc_html__("Slider controls style and position", "runcrew"),
                            "dependency" => array(
                                'slider' => array('yes')
                            ),
                            "divider" => true,
                            "value" => "",
                            "type" => "checklist",
                            "dir" => "horizontal",
                            "options" => $controls
                        ),
                        "slides_space" => array(
                            "title" => esc_html__("Space between slides", "runcrew"),
                            "desc" => esc_html__("Size of space (in px) between slides", "runcrew"),
                            "dependency" => array(
                                'slider' => array('yes')
                            ),
                            "value" => 0,
                            "min" => 0,
                            "max" => 100,
                            "step" => 10,
                            "type" => "spinner"
                        ),
                        "interval" => array(
                            "title" => esc_html__("Slides change interval", "runcrew"),
                            "desc" => esc_html__("Slides change interval (in milliseconds: 1000ms = 1s)", "runcrew"),
                            "dependency" => array(
                                'slider' => array('yes')
                            ),
                            "value" => 7000,
                            "step" => 500,
                            "min" => 0,
                            "type" => "spinner"
                        ),
                        "autoheight" => array(
                            "title" => esc_html__("Autoheight", "runcrew"),
                            "desc" => esc_html__("Change whole slider's height (make it equal current slide's height)", "runcrew"),
                            "dependency" => array(
                                'slider' => array('yes')
                            ),
                            "value" => "yes",
                            "type" => "switch",
                            "options" => runcrew_get_sc_param('yes_no')
                        ),
                        "align" => array(
                            "title" => esc_html__("Alignment", "runcrew"),
                            "desc" => esc_html__("Alignment of the events block", "runcrew"),
                            "divider" => true,
                            "value" => "",
                            "type" => "checklist",
                            "dir" => "horizontal",
                            "options" => runcrew_get_sc_param('align')
                        ),
                        "cat" => array(
                            "title" => esc_html__("Categories", "runcrew"),
                            "desc" => esc_html__("Select categories (groups) to show events list. If empty - select events from any category (group) or from IDs list", "runcrew"),
                            "divider" => true,
                            "value" => "",
                            "type" => "select",
                            "style" => "list",
                            "multiple" => true,
                            "options" => runcrew_array_merge(array(0 => esc_html__('- Select category -', 'runcrew')), $groups)
                        ),
                        "count" => array(
                            "title" => esc_html__("Number of posts", "runcrew"),
                            "desc" => esc_html__("How many posts will be displayed? If used IDs - this parameter ignored.", "runcrew"),
                            "value" => 4,
                            "min" => 1,
                            "max" => 100,
                            "type" => "spinner"
                        ),
                        "offset" => array(
                            "title" => esc_html__("Offset before select posts", "runcrew"),
                            "desc" => esc_html__("Skip posts before select next part.", "runcrew"),
                            "value" => 0,
                            "min" => 0,
                            "type" => "spinner"
                        ),
                        "orderby" => array(
                            "title" => esc_html__("Post order by", "runcrew"),
                            "desc" => esc_html__("Select desired posts sorting method", "runcrew"),
                            "value" => "title",
                            "type" => "select",
                            "options" => $sorting
                        ),
                        "order" => array(
                            "title" => esc_html__("Post order", "runcrew"),
                            "desc" => esc_html__("Select desired posts order", "runcrew"),
                            "value" => "asc",
                            "type" => "switch",
                            "size" => "big",
                            "options" => runcrew_get_sc_param('ordering')
                        ),
                        "ids" => array(
                            "title" => esc_html__("Post IDs list", "runcrew"),
                            "desc" => esc_html__("Comma separated list of posts ID. If set - parameters above are ignored!", "runcrew"),
                            "value" => "",
                            "type" => "text"
                        ),
                        "readmore" => array(
                            "title" => esc_html__("Read more", "runcrew"),
                            "desc" => esc_html__("Caption for the Read more link (if empty - link not showed)", "runcrew"),
                            "value" => "",
                            "type" => "text"
                        ),
                        "link" => array(
                            "title" => esc_html__("Button URL", "runcrew"),
                            "desc" => esc_html__("Link URL for the button at the bottom of the block", "runcrew"),
                            "value" => "",
                            "type" => "text"
                        ),
                        "link_caption" => array(
                            "title" => esc_html__("Button caption", "runcrew"),
                            "desc" => esc_html__("Caption for the button at the bottom of the block", "runcrew"),
                            "value" => "",
                            "type" => "text"
                        ),
                        "width" => runcrew_shortcodes_width(),
                        "height" => runcrew_shortcodes_height(),
                        "top" => runcrew_get_sc_param('top'),
                        "bottom" => runcrew_get_sc_param('bottom'),
                        "left" => runcrew_get_sc_param('left'),
                        "right" => runcrew_get_sc_param('right'),
                        "id" => runcrew_get_sc_param('id'),
                        "class" => runcrew_get_sc_param('class'),
                        "animation" => runcrew_get_sc_param('animation'),
                        "css" => runcrew_get_sc_param('css')
                    )
                )
            );
        }
    }
}


// Add [trx_events] in the VC shortcodes list
if (!function_exists('runcrew_tribe_events_reg_shortcodes_vc')) {
    //Handler of add_filter('runcrew_action_shortcodes_list_vc',	'runcrew_tribe_events_reg_shortcodes_vc');
    function runcrew_tribe_events_reg_shortcodes_vc() {

        $groups		= runcrew_get_list_terms(false, Tribe__Events__Main::TAXONOMY);
        $styles		= runcrew_get_list_templates('events');
        $sorting	= array(
            "event_date"=> esc_html__("Start Date", 'runcrew'),
            "title" 	=> esc_html__("Alphabetically", 'runcrew'),
            "random"	=> esc_html__("Random", 'runcrew')
        );
        $controls	= runcrew_get_list_slider_controls();

        // Events
        vc_map( array(
            "base" => "trx_events",
            "name" => esc_html__("Events", "runcrew"),
            "description" => esc_html__("Insert events list", "runcrew"),
            "category" => esc_html__('Content', 'runcrew'),
            "icon" => 'icon_trx_events',
            "class" => "trx_sc_single trx_sc_events",
            "content_element" => true,
            "is_container" => false,
            "show_settings_on_create" => true,
            "params" => array(
                array(
                    "param_name" => "style",
                    "heading" => esc_html__("Style", "runcrew"),
                    "description" => esc_html__("Select style to display events list", "runcrew"),
                    "class" => "",
                    "admin_label" => true,
                    "std" => "events-1",
                    "value" => array_flip($styles),
                    "type" => "dropdown"
                ),
                array(
                    "param_name" => "scheme",
                    "heading" => esc_html__("Color scheme", "runcrew"),
                    "description" => esc_html__("Select color scheme for this block", "runcrew"),
                    "admin_label" => true,
                    "class" => "",
                    "value" => array_flip(runcrew_get_sc_param('schemes')),
                    "type" => "dropdown"
                ),
                array(
                    "param_name" => "slider",
                    "heading" => esc_html__("Slider", "runcrew"),
                    "description" => esc_html__("Use slider to show events", "runcrew"),
                    "admin_label" => true,
                    'dependency' => array(
                        'element' => 'style',
                        'value' => 'events-1'
                    ),
                    "group" => esc_html__('Slider', 'runcrew'),
                    "class" => "",
                    "std" => "no",
                    "value" => array_flip(runcrew_get_sc_param('yes_no')),
                    "type" => "dropdown"
                ),
                array(
                    "param_name" => "controls",
                    "heading" => esc_html__("Controls", "runcrew"),
                    "description" => esc_html__("Slider controls style and position", "runcrew"),
                    "admin_label" => true,
                    "group" => esc_html__('Slider', 'runcrew'),
                    'dependency' => array(
                        'element' => 'slider',
                        'value' => 'yes'
                    ),
                    "class" => "",
                    "std" => "no",
                    "value" => array_flip($controls),
                    "type" => "dropdown"
                ),
                array(
                    "param_name" => "slides_space",
                    "heading" => esc_html__("Space between slides", "runcrew"),
                    "description" => esc_html__("Size of space (in px) between slides", "runcrew"),
                    "admin_label" => true,
                    "group" => esc_html__('Slider', 'runcrew'),
                    'dependency' => array(
                        'element' => 'slider',
                        'value' => 'yes'
                    ),
                    "class" => "",
                    "value" => "0",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "interval",
                    "heading" => esc_html__("Slides change interval", "runcrew"),
                    "description" => esc_html__("Slides change interval (in milliseconds: 1000ms = 1s)", "runcrew"),
                    "group" => esc_html__('Slider', 'runcrew'),
                    'dependency' => array(
                        'element' => 'slider',
                        'value' => 'yes'
                    ),
                    "class" => "",
                    "value" => "7000",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "autoheight",
                    "heading" => esc_html__("Autoheight", "runcrew"),
                    "description" => esc_html__("Change whole slider's height (make it equal current slide's height)", "runcrew"),
                    "group" => esc_html__('Slider', 'runcrew'),
                    'dependency' => array(
                        'element' => 'slider',
                        'value' => 'yes'
                    ),
                    "class" => "",
                    "value" => array("Autoheight" => "yes" ),
                    "type" => "checkbox"
                ),
                array(
                    "param_name" => "align",
                    "heading" => esc_html__("Alignment", "runcrew"),
                    "description" => esc_html__("Alignment of the events block", "runcrew"),
                    "class" => "",
                    "value" => array_flip(runcrew_get_sc_param('align')),
                    "type" => "dropdown"
                ),
                array(
                    "param_name" => "title",
                    "heading" => esc_html__("Title", "runcrew"),
                    "description" => esc_html__("Title for the block", "runcrew"),
                    "admin_label" => true,
                    "group" => esc_html__('Captions', 'runcrew'),
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "subtitle",
                    "heading" => esc_html__("Subtitle", "runcrew"),
                    "description" => esc_html__("Subtitle for the block", "runcrew"),
                    "group" => esc_html__('Captions', 'runcrew'),
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "description",
                    "heading" => esc_html__("Description", "runcrew"),
                    "description" => esc_html__("Description for the block", "runcrew"),
                    "group" => esc_html__('Captions', 'runcrew'),
                    "class" => "",
                    "value" => "",
                    "type" => "textarea"
                ),
                array(
                    "param_name" => "cat",
                    "heading" => esc_html__("Categories", "runcrew"),
                    "description" => esc_html__("Select category to show events. If empty - select events from any category (group) or from IDs list", "runcrew"),
                    "group" => esc_html__('Query', 'runcrew'),
                    "class" => "",
                    "value" => array_flip(runcrew_array_merge(array(0 => esc_html__('- Select category -', 'runcrew')), $groups)),
                    "type" => "dropdown"
                ),
                array(
                    "param_name" => "columns",
                    "heading" => esc_html__("Columns", "runcrew"),
                    "description" => esc_html__("How many columns use to show events list", "runcrew"),
                    "group" => esc_html__('Query', 'runcrew'),
                    "admin_label" => true,
                    "class" => "",
                    "value" => "4",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "count",
                    "heading" => esc_html__("Number of posts", "runcrew"),
                    "description" => esc_html__("How many posts will be displayed? If used IDs - this parameter ignored.", "runcrew"),
                    "admin_label" => true,
                    "group" => esc_html__('Query', 'runcrew'),
                    "class" => "",
                    "value" => "4",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "offset",
                    "heading" => esc_html__("Offset before select posts", "runcrew"),
                    "description" => esc_html__("Skip posts before select next part.", "runcrew"),
                    "group" => esc_html__('Query', 'runcrew'),
                    "class" => "",
                    "value" => "0",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "orderby",
                    "heading" => esc_html__("Post sorting", "runcrew"),
                    "description" => esc_html__("Select desired posts sorting method", "runcrew"),
                    "group" => esc_html__('Query', 'runcrew'),
                    "class" => "",
                    "value" => array_flip($sorting),
                    "type" => "dropdown"
                ),
                array(
                    "param_name" => "order",
                    "heading" => esc_html__("Post order", "runcrew"),
                    "description" => esc_html__("Select desired posts order", "runcrew"),
                    "group" => esc_html__('Query', 'runcrew'),
                    "class" => "",
                    "value" => array_flip(runcrew_get_sc_param('ordering')),
                    "type" => "dropdown"
                ),
                array(
                    "param_name" => "ids",
                    "heading" => esc_html__("Event's IDs list", "runcrew"),
                    "description" => esc_html__("Comma separated list of event's ID. If set - parameters above (category, count, order, etc.)  are ignored!", "runcrew"),
                    "group" => esc_html__('Query', 'runcrew'),
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "readmore",
                    "heading" => esc_html__("Read more", "runcrew"),
                    "description" => esc_html__("Caption for the Read more link (if empty - link not showed)", "runcrew"),
                    "admin_label" => true,
                    "group" => esc_html__('Captions', 'runcrew'),
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "link",
                    "heading" => esc_html__("Button URL", "runcrew"),
                    "description" => esc_html__("Link URL for the button at the bottom of the block", "runcrew"),
                    "group" => esc_html__('Captions', 'runcrew'),
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "link_caption",
                    "heading" => esc_html__("Button caption", "runcrew"),
                    "description" => esc_html__("Caption for the button at the bottom of the block", "runcrew"),
                    "group" => esc_html__('Captions', 'runcrew'),
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),
                runcrew_vc_width(),
                runcrew_vc_height(),
                runcrew_get_vc_param('margin_top'),
                runcrew_get_vc_param('margin_bottom'),
                runcrew_get_vc_param('margin_left'),
                runcrew_get_vc_param('margin_right'),
                runcrew_get_vc_param('id'),
                runcrew_get_vc_param('class'),
                runcrew_get_vc_param('animation'),
                runcrew_get_vc_param('css')
            )
        ) );

        class WPBakeryShortCode_Trx_Events extends RUNCREW_VC_ShortCodeSingle {}

    }
}

?>